/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.kubejs.builder;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.rhino.util.HideFromJS;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.BlockIngredient;
import es.degrassi.mmreborn.common.crafting.modifier.AdditionRecipeModifier;
import es.degrassi.mmreborn.common.crafting.modifier.IRecipeModifier;
import es.degrassi.mmreborn.common.crafting.modifier.ModifierReplacement;
import es.degrassi.mmreborn.common.crafting.modifier.MultiplicationRecipeModifier;
import es.degrassi.mmreborn.common.crafting.modifier.RecipeModifier;
import es.degrassi.mmreborn.common.crafting.modifier.SpeedRecipeModifier;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public class ModifierBuilderJS {
    private BlockIngredient ingredient;
    private final List<RecipeModifier> modifiers = Lists.newArrayList();
    private BlockPos position;

    @HideFromJS
    private ModifierBuilderJS() {
    }

    public static ModifierBuilderJS create() {
        return new ModifierBuilderJS();
    }

    public ModifierBuilderJS ingredient(JsonElement ingredient) {
        this.ingredient = (BlockIngredient)BlockIngredient.CODEC.read(JsonOps.INSTANCE, ingredient).getOrThrow();
        return this;
    }

    public ModifierBuilderJS position(int x, int y, int z) {
        this.position = new BlockPos(x, y, z);
        return this;
    }

    public ModifierBuilderJS addModifier(RecipeModifierBuilderJS modifier) {
        this.modifiers.add(modifier.build());
        return this;
    }

    public ModifierReplacement build() {
        return new ModifierReplacement(this.ingredient, this.modifiers, this.position);
    }

    public static class RecipeModifierBuilderJS {
        private RequirementType<?> target = RequirementTypeRegistration.SPEED.get();
        private IOType mode = IOType.INPUT;
        private float modifier;
        private IRecipeModifier.OPERATION operation = IRecipeModifier.OPERATION.ADDITION;
        private float chance = 1.0f;
        private float min = Float.NEGATIVE_INFINITY;
        private float max = Float.POSITIVE_INFINITY;

        @HideFromJS
        private RecipeModifierBuilderJS() {
        }

        public static RecipeModifierBuilderJS create() {
            return new RecipeModifierBuilderJS();
        }

        public RecipeModifierBuilderJS target(ResourceLocation target) {
            this.target = (RequirementType)ModularMachineryReborn.getRequirementRegistrar().get(target);
            if (this.target == null) {
                throw new IllegalArgumentException("Invalid recipe target");
            }
            if (RecipeModifier.blacklist.stream().map(RequirementType::getId).anyMatch(arg_0 -> ((ResourceLocation)target).equals(arg_0))) {
                throw new IllegalArgumentException("This type is not allowed as recipe modifier type");
            }
            return this;
        }

        public RecipeModifierBuilderJS addition() {
            this.operation = IRecipeModifier.OPERATION.ADDITION;
            return this;
        }

        public RecipeModifierBuilderJS multiply() {
            this.operation = IRecipeModifier.OPERATION.MULTIPLICATION;
            return this;
        }

        public RecipeModifierBuilderJS input() {
            this.mode = IOType.INPUT;
            return this;
        }

        public RecipeModifierBuilderJS output() {
            this.mode = IOType.OUTPUT;
            return this;
        }

        public RecipeModifierBuilderJS modifier(float modifier) {
            this.modifier = modifier;
            return this;
        }

        public RecipeModifierBuilderJS chance(float chance) {
            this.chance = chance;
            return this;
        }

        public RecipeModifierBuilderJS min(float min) {
            this.min = min;
            return this;
        }

        public RecipeModifierBuilderJS max(float max) {
            this.max = max;
            return this;
        }

        public RecipeModifier build() {
            if (this.target == RequirementTypeRegistration.SPEED.get()) {
                return new SpeedRecipeModifier(this.operation, this.modifier, this.chance, this.max, this.min);
            }
            return switch (this.operation) {
                default -> throw new MatchException(null, null);
                case IRecipeModifier.OPERATION.ADDITION -> new AdditionRecipeModifier(this.target, this.mode, this.modifier, this.chance, this.max, this.min);
                case IRecipeModifier.OPERATION.MULTIPLICATION -> new MultiplicationRecipeModifier(this.target, this.mode, this.modifier, this.chance, this.max, this.min);
            };
        }
    }
}

