/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.kubejs;

import com.google.common.collect.Maps;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.data.KubeFileResourcePack;
import dev.latvian.mods.kubejs.script.data.VirtualDataPack;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.common.integration.kubejs.MMRKubeJSPlugin;
import es.degrassi.mmreborn.common.integration.kubejs.builder.MachineBuilderJS;
import es.degrassi.mmreborn.common.integration.kubejs.function.FunctionKubeEvent;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.machine.MachineLocation;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.Resource;

public class KubeJSIntegration {
    private KubeJSIntegration() {
    }

    public static MachineLocation getMachineLocation(Resource resource, String packName, ResourceLocation id) {
        try (PackResources pack = resource.source();){
            if (pack instanceof KubeFileResourcePack) {
                MachineLocation machineLocation = MachineLocation.fromKubeJS(id, packName);
                return machineLocation;
            }
            if (pack instanceof VirtualDataPack) {
                MachineLocation machineLocation = MachineLocation.fromKubeJSScript(id, packName);
                return machineLocation;
            }
            MachineLocation machineLocation = MachineLocation.fromDefault(id, packName);
            return machineLocation;
        }
    }

    public static Map<ResourceLocation, DynamicMachine> collectMachines() {
        ScriptType.SERVER.console.info((Object)"Collecting Modular Machinery Reborn machines from JS scripts.");
        MachineBuilderJS.MachineKubeEvent event = new MachineBuilderJS.MachineKubeEvent();
        MMRKubeJSPlugin.MACHINES.post((KubeEvent)event);
        HashMap machines = Maps.newHashMap();
        AtomicReference machineId = new AtomicReference();
        try {
            event.getBuilders().forEach(builder -> {
                machineId.set(builder.getId());
                DynamicMachine machine = builder.build();
                machines.put(machine.getRegistryName(), machine);
            });
        }
        catch (Exception e) {
            ScriptType.SERVER.console.error("Couldn't build machine: " + String.valueOf(machineId.get()), (Throwable)e);
        }
        ScriptType.SERVER.console.infof("Successfully added %s Modular Machines ", new Object[]{event.getBuilders().size()});
        return machines;
    }

    public static CraftingResult sendFunctionRequirementEvent(String id, ICraftingContext context) {
        if (!MMRKubeJSPlugin.FUNCTIONS.hasListeners((Object)id)) {
            return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.function.no_listener", (Object[])new Object[]{id}));
        }
        EventResult result = MMRKubeJSPlugin.FUNCTIONS.post((KubeEvent)new FunctionKubeEvent(context), (Object)id);
        if (result.interruptTrue() || result.interruptDefault() || result.pass()) {
            return CraftingResult.success();
        }
        Object object = result.value();
        if (object instanceof Component) {
            Component error = (Component)object;
            return CraftingResult.error(error);
        }
        object = result.value();
        if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            return CraftingResult.error((Component)Component.literal((String)charSequence.toString()));
        }
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.function.interrupt"));
    }

    public static void logError(Throwable error) {
        ScriptType.SERVER.console.error("Error while processing function requirement: ", error);
    }
}

