/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.jei.category.drawable;

import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.elements.DrawableAnimated;
import mezz.jei.common.gui.elements.DrawableCombined;
import mezz.jei.common.gui.elements.OffsetDrawable;
import mezz.jei.common.gui.textures.Textures;
import net.minecraft.client.gui.GuiGraphics;

@ParametersAreNonnullByDefault
public class ProgressDrawable
implements IDrawableAnimated {
    private final int ticksPerCycle;
    private final IDrawableAnimated.StartDirection startDirection;
    private final IDrawable drawable;

    public ProgressDrawable(int ticksPerCycle, IDrawableAnimated.StartDirection startDirection) {
        this.ticksPerCycle = ticksPerCycle;
        this.startDirection = startDirection;
        this.drawable = this.createProgress();
    }

    private IDrawable createProgress() {
        Textures textures = Internal.getTextures();
        IDrawableStatic recipeArrowFilled = textures.getRecipeArrowFilled();
        DrawableAnimated animatedFill = new DrawableAnimated(recipeArrowFilled, this.ticksPerCycle, this.startDirection, false);
        DrawableCombined drawableCombined = new DrawableCombined(new IDrawable[]{textures.getRecipeArrow(), animatedFill});
        return new OffsetDrawable((IDrawable)drawableCombined, 0, 0);
    }

    public int getWidth() {
        return this.drawable.getWidth();
    }

    public int getHeight() {
        return this.drawable.getHeight();
    }

    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        this.drawable.draw(guiGraphics, xOffset, yOffset);
    }
}

