/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.emi.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.platform.EmiClient;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.client.container.ControllerContainer;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementItem;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiItemComponent;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.integration.emi.MMREmiPlugin;
import es.degrassi.mmreborn.common.integration.emi.recipe.MMREmiRecipe;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.ItemComponent;
import es.degrassi.mmreborn.common.network.client.emi.FillRecipeC2SPacket;
import es.degrassi.mmreborn.common.util.MMRLogger;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.ApiStatus;

public class MMREmiRecipeHandler
implements StandardRecipeHandler<ControllerContainer> {
    public static final Component NO_ITEMS = EmiPort.translatable((String)"mmr.emi.no_items");
    private final DynamicMachine machine;
    private static final Map<ControllerContainer, List<Slot>> slots = Maps.newHashMap();

    public MMREmiRecipeHandler(DynamicMachine machine) {
        this.machine = machine;
    }

    public static List<Slot> getSlots(ControllerContainer handler) {
        return slots.computeIfAbsent(handler, MMREmiRecipeHandler::createSlots);
    }

    private static List<Slot> createSlots(ControllerContainer handler) {
        AtomicInteger slot = new AtomicInteger(0);
        ArrayList slots = Lists.newArrayList(handler.slots.stream().peek(s -> {
            s.index = slot.getAndIncrement();
        }).iterator());
        slots.addAll(((MachineControllerEntity)handler.getEntity()).getComponentManager().getItemComponent(IOType.INPUT).map(ItemComponent::getContainerProvider).map(inventory -> inventory.createSlots(handler.getPlayer())).stream().flatMap(Collection::stream).toList());
        return slots;
    }

    public EmiPlayerInventory getInventory(AbstractContainerScreen<ControllerContainer> screen) {
        return new EmiPlayerInventory(MMREmiRecipeHandler.getSlots((ControllerContainer)screen.getMenu()).stream().map(Slot::getItem).map(EmiStack::of).toList());
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<ControllerContainer> context) {
        if (recipe.getInputs().isEmpty()) {
            return false;
        }
        return context.getInventory().canCraft(recipe);
    }

    public List<Slot> getInputSources(ControllerContainer handler) {
        return MMREmiRecipeHandler.getSlots(handler);
    }

    public List<Slot> getCraftingSlots(ControllerContainer handler) {
        List<Slot> slots = MMREmiRecipeHandler.getSlots(handler);
        return slots.subList(36, slots.size());
    }

    public boolean craft(EmiRecipe r, EmiCraftContext<ControllerContainer> context) {
        if (!(r instanceof MMREmiRecipe)) {
            return false;
        }
        MMREmiRecipe recipe = (MMREmiRecipe)r;
        List<ItemStack> stacks = this.getStacks(recipe, (AbstractContainerScreen<ControllerContainer>)context.getScreen(), context.getAmount());
        if (!stacks.isEmpty()) {
            Minecraft.getInstance().setScreen((Screen)context.getScreen());
            if (!EmiClient.onServer) {
                return this.clientFill(recipe, (AbstractContainerScreen<ControllerContainer>)context.getScreen(), stacks, context.getDestination());
            }
            AbstractContainerScreen abstractContainerScreen = context.getScreen();
            int n = ((ControllerContainer)context.getScreenHandler()).containerId;
            this.sendFillRecipe((AbstractContainerScreen<ControllerContainer>)abstractContainerScreen, n, switch (context.getDestination()) {
                default -> throw new MatchException(null, null);
                case EmiCraftContext.Destination.NONE -> 0;
                case EmiCraftContext.Destination.CURSOR -> 1;
                case EmiCraftContext.Destination.INVENTORY -> 2;
            }, stacks, recipe);
            return true;
        }
        return false;
    }

    public List<ItemStack> getStacks(MMREmiRecipe recipe, AbstractContainerScreen<ControllerContainer> screen, int amount) {
        ArrayList stacks = Lists.newArrayList();
        try {
            ControllerContainer screenHandler = (ControllerContainer)screen.getMenu();
            ((MachineControllerEntity)screenHandler.getEntity()).getComponentManager().getItemComponent(IOType.INPUT).map(ItemComponent::getContainerProvider).ifPresent(inventory -> {
                List ingredients = recipe.getInputs();
                Player player = screenHandler.getPlayer();
                List<Slot> slots = inventory.createSlots(player);
                List<Slot> crafting = inventory.createInventorySlots(Lists.newArrayList(), 0);
                List<Integer> ss = this.getInputSources(screenHandler).stream().map(s -> s == null ? -1 : s.index).toList();
                List<Integer> cs = this.getCraftingSlots(screenHandler).stream().map(s -> s == null ? -1 : s.index).toList();
                ArrayList discovered = Lists.newArrayList();
                Object2IntOpenHashMap weightDivider = new Object2IntOpenHashMap();
                for (int i = 0; i < ingredients.size(); ++i) {
                    Object stack;
                    ArrayList d = Lists.newArrayList();
                    EmiIngredient ingredient = (EmiIngredient)ingredients.get(i);
                    List emiStacks = ingredient.getEmiStacks();
                    if (ingredient.isEmpty()) {
                        discovered.add(null);
                        continue;
                    }
                    Iterator iterator = emiStacks.iterator();
                    while (iterator.hasNext()) {
                        stack = (EmiStack)iterator.next();
                        block2: for (Slot slot : slots) {
                            ItemStack is = slot.getItem();
                            if (!EmiStack.of((ItemStack)is).isEqual((EmiStack)stack)) continue;
                            Iterator iterator2 = d.iterator();
                            while (iterator2.hasNext()) {
                                DiscoveredItem di = (DiscoveredItem)iterator2.next();
                                if (!ItemStack.isSameItemSameComponents((ItemStack)is, (ItemStack)di.stack)) continue;
                                di.amount += is.getCount();
                                continue block2;
                            }
                            d.add(new DiscoveredItem((EmiStack)stack, is, is.getCount(), (int)ingredient.getAmount(), is.getMaxStackSize()));
                        }
                    }
                    DiscoveredItem biggest = null;
                    stack = d.iterator();
                    while (stack.hasNext()) {
                        DiscoveredItem di = (DiscoveredItem)stack.next();
                        if (biggest == null) {
                            biggest = di;
                            continue;
                        }
                        int a = di.amount / (weightDivider.getOrDefault((Object)di.ingredient, 0) + di.consumed);
                        int ba = biggest.amount / (weightDivider.getOrDefault((Object)biggest.ingredient, 0) + biggest.consumed);
                        if (ba >= a) continue;
                        biggest = di;
                    }
                    if (biggest == null || i >= crafting.size()) {
                        return;
                    }
                    Slot slot = crafting.get(i);
                    if (slot == null) {
                        return;
                    }
                    weightDivider.put((Object)biggest.ingredient, weightDivider.getOrDefault((Object)biggest.ingredient, 0) + biggest.consumed);
                    biggest.max = Math.min(biggest.max, slot.getItem().getMaxStackSize());
                    discovered.add(biggest);
                }
                if (discovered.isEmpty()) {
                    return;
                }
                ArrayList unique = Lists.newArrayList();
                block5: for (DiscoveredItem di : discovered) {
                    if (di == null) continue;
                    for (DiscoveredItem ui : unique) {
                        if (!ItemStack.isSameItemSameComponents((ItemStack)di.stack, (ItemStack)ui.stack)) continue;
                        ui.consumed += di.consumed;
                        continue block5;
                    }
                    unique.add(new DiscoveredItem(di.ingredient, di.stack, di.amount, di.consumed, di.max));
                }
                int maxAmount = Integer.MAX_VALUE;
                for (DiscoveredItem ui : unique) {
                    if (ui.catalyst()) continue;
                    maxAmount = Math.min(maxAmount, Math.min(ui.amount / ui.consumed, ui.max));
                }
                if ((maxAmount = Math.min(maxAmount, amount + this.batchesAlreadyPresent(recipe, screen))) == 0) {
                    return;
                }
                for (DiscoveredItem di : discovered) {
                    if (di != null) {
                        ItemStack is = di.stack.copy();
                        int a = di.catalyst() ? di.consumed : di.consumed * maxAmount;
                        is.setCount(a);
                        stacks.add(is);
                        continue;
                    }
                    stacks.add(ItemStack.EMPTY);
                }
            });
        }
        catch (Exception e) {
            MMRLogger.INSTANCE.error((Object)e);
        }
        return stacks;
    }

    public int batchesAlreadyPresent(MMREmiRecipe recipe, AbstractContainerScreen<ControllerContainer> screen) {
        List ingredients = recipe.getInputs();
        ArrayList stacks = Lists.newArrayList();
        Slot output = this.getOutputSlot((ControllerContainer)screen.getMenu());
        if (!(output == null || output.getItem().isEmpty() || recipe.getOutputs().isEmpty() || ItemStack.matches((ItemStack)output.getItem(), (ItemStack)recipe.getOutputs().stream().filter(stack -> stack instanceof ItemEmiStack).toList().get(0).getItemStack()))) {
            return 0;
        }
        for (Slot slot : this.getCraftingSlots((ControllerContainer)screen.getMenu())) {
            if (slot != null) {
                stacks.add(slot.getItem());
                continue;
            }
            stacks.add(ItemStack.EMPTY);
        }
        long amount = Long.MAX_VALUE;
        block1: for (int i = 0; i < ingredients.size(); ++i) {
            EmiIngredient input = (EmiIngredient)ingredients.get(i);
            if (input.isEmpty()) {
                if (((ItemStack)stacks.get(i)).isEmpty()) continue;
                return 0;
            }
            if (i >= stacks.size()) {
                return 0;
            }
            EmiStack es = EmiStack.of((ItemStack)((ItemStack)stacks.get(i)));
            for (EmiStack v : input.getEmiStacks()) {
                if (v.isEmpty() || !v.isEqual(es) || es.getAmount() < v.getAmount()) continue;
                amount = Math.min(amount, es.getAmount() / v.getAmount());
                continue block1;
            }
            return 0;
        }
        if (amount < Long.MAX_VALUE && amount > 0L) {
            return (int)amount;
        }
        return 0;
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe.getCategory() == MMREmiPlugin.categories.get(this.machine);
    }

    public void render(EmiRecipe recipe, EmiCraftContext<ControllerContainer> context, List<Widget> widgets, GuiGraphics draw) {
        MMREmiRecipeHandler.renderMissing(recipe, context.getInventory(), widgets, draw);
    }

    @ApiStatus.Internal
    public static void renderMissing(EmiRecipe recipe, EmiPlayerInventory inv, List<Widget> widgets, GuiGraphics draw) {
        RenderSystem.enableDepthTest();
        Map<EmiIngredient, Boolean> availableForCrafting = MMREmiRecipeHandler.getAvailable(recipe, inv);
        block0: for (Widget w : widgets) {
            if (!(w instanceof EmiItemComponent)) continue;
            EmiItemComponent sw = (EmiItemComponent)w;
            EmiIngredient stack = sw.getIngredient();
            for (Map.Entry<EmiIngredient, Boolean> entry : availableForCrafting.entrySet()) {
                if (!((RequirementItem)((RecipeRequirement)sw.getRequirement()).requirement()).getMode().isInput() || stack.isEmpty()) continue block0;
                if (!EmiIngredient.areEqual((EmiIngredient)stack, (EmiIngredient)entry.getKey()) || entry.getValue().booleanValue()) continue;
                draw.fill(sw.getX() + 1, sw.getY() + 1, sw.getX() + 1 + sw.getWidth(), sw.getY() + 1 + sw.getHeight(), 200, 0x44FF0000);
                continue block0;
            }
        }
    }

    private static Map<EmiIngredient, Boolean> getAvailable(EmiRecipe recipe, EmiPlayerInventory inventory) {
        IdentityHashMap<EmiIngredient, Boolean> availableForCrafting = new IdentityHashMap<EmiIngredient, Boolean>();
        List inputs = recipe.getInputs();
        List<Boolean> list = MMREmiRecipeHandler.getCraftAvailability(inventory.inventory, inputs);
        if (list.size() != inputs.size()) {
            return Map.of();
        }
        for (int i = 0; i < list.size(); ++i) {
            availableForCrafting.put((EmiIngredient)inputs.get(i), list.get(i));
        }
        return availableForCrafting;
    }

    public static List<Boolean> getCraftAvailability(Map<EmiStack, EmiStack> inventory, List<EmiIngredient> inputs) {
        Object2LongOpenHashMap used = new Object2LongOpenHashMap();
        ArrayList states = Lists.newArrayList();
        block0: for (EmiIngredient ingredient : inputs) {
            for (EmiStack stack : ingredient.getEmiStacks()) {
                long desired = stack.getAmount();
                if (!inventory.containsKey(stack)) continue;
                EmiStack identity = inventory.get(stack);
                long alreadyUsed = used.getOrDefault((Object)identity, 0L);
                long available = identity.getAmount() - alreadyUsed;
                if (available < desired) continue;
                used.put((Object)identity, desired + alreadyUsed);
                states.add(true);
                continue block0;
            }
            states.add(false);
        }
        return states;
    }

    public void sendFillRecipe(AbstractContainerScreen<ControllerContainer> screen, int syncId, int action, List<ItemStack> stacks, MMREmiRecipe recipe) {
        ControllerContainer screenHandler = (ControllerContainer)screen.getMenu();
        List crafting = this.getCraftingSlots((EmiRecipe)recipe, screenHandler);
        Slot output = this.getOutputSlot(screenHandler);
        PacketDistributor.sendToServer((CustomPacketPayload)new FillRecipeC2SPacket(screenHandler, action, this.getInputSources(screenHandler), crafting, output, stacks), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean clientFill(MMREmiRecipe recipe, AbstractContainerScreen<ControllerContainer> screen, List<ItemStack> stacks, EmiCraftContext.Destination destination) {
        ControllerContainer screenHandler = (ControllerContainer)screen.getMenu();
        if (screenHandler.getCarried().isEmpty()) {
            Minecraft client = Minecraft.getInstance();
            MultiPlayerGameMode manager = client.gameMode;
            LocalPlayer player = client.player;
            List<Slot> clear = this.getCraftingSlots(screenHandler);
            for (Slot slot : clear) {
                if (slot == null) continue;
                manager.handleInventoryMouseClick(screenHandler.containerId, slot.index, 0, ClickType.QUICK_MOVE, (Player)player);
            }
            List<Slot> inputs = this.getInputSources(screenHandler);
            List slots = this.getCraftingSlots((EmiRecipe)recipe, screenHandler);
            block1: for (int i = 0; i < stacks.size(); ++i) {
                ItemStack stack = stacks.get(i);
                if (stack.isEmpty()) continue;
                if (i >= slots.size()) {
                    return false;
                }
                Slot crafting = (Slot)slots.get(i);
                if (crafting == null) {
                    return false;
                }
                int needed = stack.getCount();
                for (Slot input : inputs) {
                    if (slots.contains(input)) continue;
                    ItemStack is = input.getItem().copy();
                    if (ItemStack.isSameItemSameComponents((ItemStack)is, (ItemStack)stack)) {
                        manager.handleInventoryMouseClick(screenHandler.containerId, input.index, 0, ClickType.PICKUP, (Player)player);
                        if (is.getCount() <= needed) {
                            needed -= is.getCount();
                            manager.handleInventoryMouseClick(screenHandler.containerId, crafting.index, 0, ClickType.PICKUP, (Player)player);
                        } else {
                            while (needed > 0) {
                                manager.handleInventoryMouseClick(screenHandler.containerId, crafting.index, 1, ClickType.PICKUP, (Player)player);
                                --needed;
                            }
                            manager.handleInventoryMouseClick(screenHandler.containerId, input.index, 0, ClickType.PICKUP, (Player)player);
                        }
                    }
                    if (needed != 0) continue;
                    continue block1;
                }
                return false;
            }
            Slot slot = this.getOutputSlot(screenHandler);
            if (slot != null) {
                if (destination == EmiCraftContext.Destination.CURSOR) {
                    manager.handleInventoryMouseClick(screenHandler.containerId, slot.index, 0, ClickType.PICKUP, (Player)player);
                } else if (destination == EmiCraftContext.Destination.INVENTORY) {
                    manager.handleInventoryMouseClick(screenHandler.containerId, slot.index, 0, ClickType.QUICK_MOVE, (Player)player);
                }
            }
            return true;
        }
        return false;
    }

    public List<ClientTooltipComponent> getTooltip(EmiRecipe recipe, EmiCraftContext<ControllerContainer> context) {
        if (this.canCraft(recipe, context)) {
            return List.of();
        }
        if (!recipe.getInputs().isEmpty()) {
            return List.of(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)NOT_ENOUGH_INGREDIENTS)));
        }
        return List.of(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)NO_ITEMS)));
    }

    private static class DiscoveredItem {
        private static final Comparison COMPARISON = Comparison.DEFAULT_COMPARISON;
        public EmiStack ingredient;
        public ItemStack stack;
        public int consumed;
        public int amount;
        public int max;

        public DiscoveredItem(EmiStack ingredient, ItemStack stack, int amount, int consumed, int max) {
            this.ingredient = ingredient;
            this.stack = stack.copy();
            this.amount = amount;
            this.consumed = consumed;
            this.max = max;
        }

        public boolean catalyst() {
            return this.ingredient.getRemainder().isEqual(this.ingredient, COMPARISON);
        }
    }
}

