/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.emi.recipe;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.widget.WidgetHolder;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.api.integration.emi.Direction;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementDuration;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiDurationComponent;
import es.degrassi.mmreborn.common.integration.emi.EmiComponentRegistry;
import es.degrassi.mmreborn.common.integration.emi.EmiIngredientRegistry;
import es.degrassi.mmreborn.common.integration.emi.EmiStackRegistry;
import es.degrassi.mmreborn.common.machine.component.DurationComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.crafting.RecipeHolder;

public class MMREmiRecipe
extends BasicEmiRecipe {
    private final MachineRecipe recipe;
    public final int initialX = 8;
    public final int gap = 8;
    protected int width = 256;
    protected int height = 256;
    public final List<FormattedText> textsToRender = Lists.newArrayList();

    public MMREmiRecipe(EmiRecipeCategory category, RecipeHolder<MachineRecipe> recipe) {
        super(category, recipe.id(), ((MachineRecipe)recipe.value()).getWidth(), ((MachineRecipe)recipe.value()).getHeight());
        this.recipe = (MachineRecipe)recipe.value();
        this.inputs = this.recipe.getRequirements().stream().filter(requirement -> requirement.requirement().getMode().isInput()).filter(requirement -> EmiIngredientRegistry.hasEmiIngredient(requirement.getType())).map(requirement -> requirement.castRequirement((RecipeRequirement<?, ?>)requirement)).map(requirement -> EmiIngredientRegistry.getIngredient(requirement.getType()).create((RecipeRequirement)requirement)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        this.outputs = this.recipe.getRequirements().stream().filter(requirement -> !requirement.requirement().getMode().isInput()).filter(requirement -> EmiStackRegistry.hasEmiStack(requirement.getType())).map(requirement -> requirement.castRequirement((RecipeRequirement<?, ?>)requirement)).map(requirement -> EmiStackRegistry.getStack(requirement.getType()).create((RecipeRequirement)requirement)).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
        this.catalysts = this.recipe.getRequirements().stream().filter(requirement -> requirement.requirement().getMode().isInput()).filter(requirement -> EmiStackRegistry.hasEmiStack(requirement.getType())).map(requirement -> requirement.castRequirement((RecipeRequirement<?, ?>)requirement)).map(requirement -> EmiStackRegistry.getStack(requirement.getType()).create((RecipeRequirement)requirement)).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
    }

    public void addWidgets(WidgetHolder widgets) {
        this.textsToRender.clear();
        if (this.recipe.isShouldRenderProgress()) {
            new EmiDurationComponent(new RecipeRequirement<DurationComponent, RequirementDuration>(new RequirementDuration(this.recipe.getRecipeTotalTickTime(), this.recipe.getProgressPosition())), 1000, Direction.LEFT, false).addWidgets(widgets, this);
        }
        Font font = Minecraft.getInstance().font;
        (this.recipe.getJeiRequirements().isEmpty() ? this.recipe.getRequirements() : this.recipe.getJeiRequirements()).stream().filter(component -> EmiComponentRegistry.hasEmiComponent(component.getType())).map(requirement -> requirement.castRequirement((RecipeRequirement<?, ?>)requirement)).map(component -> EmiComponentRegistry.getEmiComponent(component.getType()).create((RecipeRequirement)component)).forEach(requirement -> requirement.addWidgets(widgets, this));
        Language language = Language.getInstance();
        AtomicInteger nextHeight = new AtomicInteger(0);
        AtomicInteger toRemove = new AtomicInteger(0);
        this.textsToRender.forEach(component -> {
            nextHeight.set(this.recipe.getHeight() - 8 - font.wordWrapHeight(component, this.recipe.getWidth() - 8) - toRemove.get());
            widgets.addText(language.getVisualOrder(component), 8, nextHeight.get(), -16777216, false);
            toRemove.getAndAdd(font.wordWrapHeight(component, this.recipe.getWidth() - 8) + 2);
        });
    }

    @Generated
    public MachineRecipe getRecipe() {
        return this.recipe;
    }

    @Generated
    public int getWidth() {
        return this.width;
    }

    @Generated
    public int getHeight() {
        return this.height;
    }
}

