/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity.base;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.controller.ControllerAccessible;
import es.degrassi.mmreborn.client.model.hatch.HatchBakedModel;
import es.degrassi.mmreborn.common.block.prop.ItemBusSize;
import es.degrassi.mmreborn.common.entity.ItemInputBusEntity;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.TextureableMachineEntity;
import es.degrassi.mmreborn.common.entity.base.TileInventory;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineHatchType;
import es.degrassi.mmreborn.common.machine.component.ItemComponent;
import es.degrassi.mmreborn.common.network.server.SUpdateMachineTexturePacket;
import es.degrassi.mmreborn.common.network.server.component.SUpdateItemComponentPacket;
import es.degrassi.mmreborn.common.registration.MachineHatchTypeRegistration;
import es.degrassi.mmreborn.common.util.IOInventory;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class TileItemBus
extends TileInventory
implements MachineComponentEntity<ItemComponent>,
ControllerAccessible,
TextureableMachineEntity {
    private BlockPos controllerPos;
    private ItemBusSize size;
    private IOType ioType;
    private ResourceLocation baseTexture;
    private ResourceLocation overlayTexture;
    private ResourceLocation defaultOverlayTexture;
    private static final ResourceLocation defaultBaseTexture = ModularMachineryReborn.rl("block/casing_plain");

    protected TileItemBus(BlockEntityType<?> entityType, BlockPos pos, BlockState blockState, ItemBusSize size, IOType ioType) {
        super(entityType, pos, blockState, size.getSlotCount());
        this.size = size;
        this.ioType = ioType;
        this.overlayTexture = this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_" + ioType.getSerializedName() + "bus_" + size.getSerializedName());
        this.inventory.setListener(new IOInventory.IOInventoryChangedListener(){

            @Override
            public void onChange(int slot, ItemStack stack) {
                Level level;
                if (TileItemBus.this.getController() != null) {
                    TileItemBus.this.getController().getProcessor().setMachineInventoryChanged();
                }
                if ((level = TileItemBus.this.getLevel()) instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(TileItemBus.this.getBlockPos()), (CustomPacketPayload)new SUpdateItemComponentPacket(slot, stack, TileItemBus.this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }

            @Override
            public void onChange() {
                for (int slot = 0; slot < TileItemBus.this.inventory.getSlots(); ++slot) {
                    this.onChange(slot, TileItemBus.this.inventory.getStackInSlot(slot));
                }
            }
        });
    }

    @Override
    @Nullable
    public ItemComponent provideComponent() {
        return new ItemComponent(this.getInventory(), this.ioType);
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.size = ItemBusSize.value(compound.getString("busSize"));
        this.ioType = IOType.getByString(compound.getString("ioType"));
        if (compound.contains("controllerPos")) {
            this.controllerPos = BlockPos.of((long)compound.getLong("controllerPos"));
        }
        this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_" + this.ioType.getSerializedName() + "bus_" + this.size.getSerializedName());
        this.baseTexture = compound.contains("baseTexture") ? ResourceLocation.parse((String)compound.getString("baseTexture")) : defaultBaseTexture;
        this.overlayTexture = compound.contains("overlayTexture") ? ResourceLocation.parse((String)compound.getString("overlayTexture")) : this.defaultOverlayTexture;
        this.inventory.setListener(new IOInventory.IOInventoryChangedListener(){

            @Override
            public void onChange(int slot, ItemStack stack) {
                Level level;
                if (TileItemBus.this.getController() != null) {
                    TileItemBus.this.getController().getProcessor().setMachineInventoryChanged();
                }
                if ((level = TileItemBus.this.getLevel()) instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(TileItemBus.this.getBlockPos()), (CustomPacketPayload)new SUpdateItemComponentPacket(slot, stack, TileItemBus.this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }

            @Override
            public void onChange() {
                for (int slot = 0; slot < TileItemBus.this.inventory.getSlots(); ++slot) {
                    this.onChange(slot, TileItemBus.this.inventory.getStackInSlot(slot));
                }
            }
        });
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.putString("busSize", this.size.getSerializedName());
        if (this.ioType == null) {
            this.ioType = this instanceof ItemInputBusEntity ? IOType.INPUT : IOType.OUTPUT;
        }
        compound.putString("ioType", this.ioType.getSerializedName());
        if (this.controllerPos != null) {
            compound.putLong("controllerPos", this.controllerPos.asLong());
        }
        if (this.baseTexture != null) {
            compound.putString("baseTexture", this.baseTexture.toString());
        }
        if (this.overlayTexture != null) {
            compound.putString("overlayTexture", this.overlayTexture.toString());
        }
    }

    @Override
    public void setControllerPos(BlockPos pos) {
        this.controllerPos = pos;
    }

    public ModelData getModelData() {
        ModelData.Builder builder = this.getModelDataBuilder("all");
        builder.with(HatchBakedModel.BASE_TEXTURE, (Object)this.baseTexture).with(HatchBakedModel.BASE_TEXTURE_NAME, (Object)"bg_all");
        builder.with(HatchBakedModel.OVERLAY_TEXTURE, (Object)this.overlayTexture).with(HatchBakedModel.OVERLAY_TEXTURE_NAME, (Object)"ov_all");
        return builder.build();
    }

    @Override
    public ResourceLocation getMachineBaseTexture() {
        return this.baseTexture;
    }

    @Override
    public ResourceLocation getMachineOverlayTexture() {
        return this.overlayTexture;
    }

    @Override
    public void setMachineBaseTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.baseTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.baseTexture, true, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void setMachineOverlayTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.overlayTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.overlayTexture, false, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void resetTextures() {
        this.setMachineBaseTexture(defaultBaseTexture);
        this.setMachineOverlayTexture(this.defaultOverlayTexture);
    }

    @Override
    public MachineHatchType getHatchType() {
        return switch (this.ioType) {
            case IOType.INPUT -> {
                Supplier<MachineHatchType> v0 = switch (this.size) {
                    default -> throw new MatchException(null, null);
                    case ItemBusSize.TINY -> MachineHatchTypeRegistration.ITEM_INPUT_BUS_TINY;
                    case ItemBusSize.SMALL -> MachineHatchTypeRegistration.ITEM_INPUT_BUS_SMALL;
                    case ItemBusSize.NORMAL -> MachineHatchTypeRegistration.ITEM_INPUT_BUS_NORMAL;
                    case ItemBusSize.REINFORCED -> MachineHatchTypeRegistration.ITEM_INPUT_BUS_REINFORCED;
                    case ItemBusSize.BIG -> MachineHatchTypeRegistration.ITEM_INPUT_BUS_BIG;
                    case ItemBusSize.HUGE -> MachineHatchTypeRegistration.ITEM_INPUT_BUS_HUGE;
                    case ItemBusSize.LUDICROUS -> MachineHatchTypeRegistration.ITEM_INPUT_BUS_LUDICROUS;
                };
                yield v0.get();
            }
            case IOType.OUTPUT -> {
                Supplier<MachineHatchType> v2 = switch (this.size) {
                    default -> throw new MatchException(null, null);
                    case ItemBusSize.TINY -> MachineHatchTypeRegistration.ITEM_OUTPUT_BUS_TINY;
                    case ItemBusSize.SMALL -> MachineHatchTypeRegistration.ITEM_OUTPUT_BUS_SMALL;
                    case ItemBusSize.NORMAL -> MachineHatchTypeRegistration.ITEM_OUTPUT_BUS_NORMAL;
                    case ItemBusSize.REINFORCED -> MachineHatchTypeRegistration.ITEM_OUTPUT_BUS_REINFORCED;
                    case ItemBusSize.BIG -> MachineHatchTypeRegistration.ITEM_OUTPUT_BUS_BIG;
                    case ItemBusSize.HUGE -> MachineHatchTypeRegistration.ITEM_OUTPUT_BUS_HUGE;
                    case ItemBusSize.LUDICROUS -> MachineHatchTypeRegistration.ITEM_OUTPUT_BUS_LUDICROUS;
                };
                yield v2.get();
            }
            default -> null;
        };
    }

    @Override
    @Generated
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Generated
    public ItemBusSize getSize() {
        return this.size;
    }

    @Generated
    public IOType getIoType() {
        return this.ioType;
    }

    @Generated
    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    @Generated
    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    @Generated
    public ResourceLocation getDefaultOverlayTexture() {
        return this.defaultOverlayTexture;
    }

    @Generated
    public static ResourceLocation getDefaultBaseTexture() {
        return defaultBaseTexture;
    }
}

