/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity.base;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.controller.ControllerAccessible;
import es.degrassi.mmreborn.client.model.hatch.HatchBakedModel;
import es.degrassi.mmreborn.common.block.prop.ItemDurabilityHatchSize;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.TextureableMachineEntity;
import es.degrassi.mmreborn.common.entity.base.TileInventory;
import es.degrassi.mmreborn.common.machine.MachineHatchType;
import es.degrassi.mmreborn.common.machine.component.DurabilityComponent;
import es.degrassi.mmreborn.common.network.server.SUpdateMachineTexturePacket;
import es.degrassi.mmreborn.common.network.server.component.SUpdateItemComponentPacket;
import es.degrassi.mmreborn.common.registration.EntityRegistration;
import es.degrassi.mmreborn.common.registration.MachineHatchTypeRegistration;
import es.degrassi.mmreborn.common.util.IOInventory;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.network.PacketDistributor;

public class DurabilityHatchEntity
extends TileInventory
implements MachineComponentEntity<DurabilityComponent>,
ControllerAccessible,
TextureableMachineEntity {
    private BlockPos controllerPos;
    private ItemDurabilityHatchSize size;
    private ResourceLocation baseTexture;
    private ResourceLocation overlayTexture;
    private ResourceLocation defaultOverlayTexture;
    private static final ResourceLocation defaultBaseTexture = ModularMachineryReborn.rl("block/casing_plain");

    private DurabilityHatchEntity(BlockEntityType<?> entityType, BlockPos pos, BlockState blockState, ItemDurabilityHatchSize size) {
        super(entityType, pos, blockState, size.getSlotCount());
        this.size = size;
        this.overlayTexture = this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_durabilityhatch_" + size.getSerializedName());
        this.inventory.setListener(new IOInventory.IOInventoryChangedListener(){

            @Override
            public void onChange(int slot, ItemStack stack) {
                Level level;
                if (DurabilityHatchEntity.this.getController() != null) {
                    DurabilityHatchEntity.this.getController().getProcessor().setMachineInventoryChanged();
                }
                if ((level = DurabilityHatchEntity.this.getLevel()) instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(DurabilityHatchEntity.this.getBlockPos()), (CustomPacketPayload)new SUpdateItemComponentPacket(slot, stack, DurabilityHatchEntity.this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }

            @Override
            public void onChange() {
                for (int slot = 0; slot < DurabilityHatchEntity.this.inventory.getSlots(); ++slot) {
                    this.onChange(slot, DurabilityHatchEntity.this.inventory.getStackInSlot(slot));
                }
            }
        });
    }

    public DurabilityHatchEntity(BlockPos pos, BlockState blockState, ItemDurabilityHatchSize size) {
        this(EntityRegistration.ITEM_DURABILITY_HATCH.get(), pos, blockState, size);
    }

    public DurabilityHatchEntity(BlockPos pos, BlockState blockState) {
        this(EntityRegistration.ITEM_DURABILITY_HATCH.get(), pos, blockState, ItemDurabilityHatchSize.TINY);
    }

    @Override
    public IOInventory buildInventory(int slots) {
        int[] inSlots = new int[slots];
        for (int i = 0; i < slots; ++i) {
            inSlots[i] = i;
        }
        return new IOInventory(inSlots, new int[0], stack -> stack.has(DataComponents.DAMAGE), Direction.values());
    }

    @Override
    @Nullable
    public DurabilityComponent provideComponent() {
        return new DurabilityComponent(this.getInventory());
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.size = ItemDurabilityHatchSize.value(compound.getString("busSize"));
        if (compound.contains("controllerPos")) {
            this.controllerPos = BlockPos.of((long)compound.getLong("controllerPos"));
        }
        this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_durabilityhatch_" + this.size.getSerializedName());
        this.baseTexture = compound.contains("baseTexture") ? ResourceLocation.parse((String)compound.getString("baseTexture")) : defaultBaseTexture;
        this.overlayTexture = compound.contains("overlayTexture") ? ResourceLocation.parse((String)compound.getString("overlayTexture")) : this.defaultOverlayTexture;
        this.inventory.setListener(new IOInventory.IOInventoryChangedListener(){

            @Override
            public void onChange(int slot, ItemStack stack) {
                Level level;
                if (DurabilityHatchEntity.this.getController() != null) {
                    DurabilityHatchEntity.this.getController().getProcessor().setMachineInventoryChanged();
                }
                if ((level = DurabilityHatchEntity.this.getLevel()) instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(DurabilityHatchEntity.this.getBlockPos()), (CustomPacketPayload)new SUpdateItemComponentPacket(slot, stack, DurabilityHatchEntity.this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }

            @Override
            public void onChange() {
                for (int slot = 0; slot < DurabilityHatchEntity.this.inventory.getSlots(); ++slot) {
                    this.onChange(slot, DurabilityHatchEntity.this.inventory.getStackInSlot(slot));
                }
            }
        });
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.putString("busSize", this.size.getSerializedName());
        if (this.controllerPos != null) {
            compound.putLong("controllerPos", this.controllerPos.asLong());
        }
        if (this.baseTexture != null) {
            compound.putString("baseTexture", this.baseTexture.toString());
        }
        if (this.overlayTexture != null) {
            compound.putString("overlayTexture", this.overlayTexture.toString());
        }
    }

    @Override
    public void setControllerPos(BlockPos pos) {
        this.controllerPos = pos;
    }

    public ModelData getModelData() {
        ModelData.Builder builder = this.getModelDataBuilder("all");
        builder.with(HatchBakedModel.BASE_TEXTURE, (Object)this.baseTexture).with(HatchBakedModel.BASE_TEXTURE_NAME, (Object)"bg_all");
        builder.with(HatchBakedModel.OVERLAY_TEXTURE, (Object)this.overlayTexture).with(HatchBakedModel.OVERLAY_TEXTURE_NAME, (Object)"ov_all");
        return builder.build();
    }

    @Override
    public ResourceLocation getMachineBaseTexture() {
        return this.baseTexture;
    }

    @Override
    public ResourceLocation getMachineOverlayTexture() {
        return this.overlayTexture;
    }

    @Override
    public void setMachineBaseTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.baseTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.baseTexture, true, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void setMachineOverlayTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.overlayTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.overlayTexture, false, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void resetTextures() {
        this.setMachineBaseTexture(defaultBaseTexture);
        this.setMachineOverlayTexture(this.defaultOverlayTexture);
    }

    @Override
    public MachineHatchType getHatchType() {
        return (switch (this.size) {
            default -> throw new MatchException(null, null);
            case ItemDurabilityHatchSize.TINY -> MachineHatchTypeRegistration.DURABILITY_HATCH_TINY;
            case ItemDurabilityHatchSize.SMALL -> MachineHatchTypeRegistration.DURABILITY_HATCH_SMALL;
            case ItemDurabilityHatchSize.NORMAL -> MachineHatchTypeRegistration.DURABILITY_HATCH_NORMAL;
            case ItemDurabilityHatchSize.BIG -> MachineHatchTypeRegistration.DURABILITY_HATCH_BIG;
        }).get();
    }

    @Override
    @Generated
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Generated
    public ItemDurabilityHatchSize getSize() {
        return this.size;
    }

    @Generated
    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    @Generated
    public void setBaseTexture(ResourceLocation baseTexture) {
        this.baseTexture = baseTexture;
    }

    @Generated
    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    @Generated
    public void setOverlayTexture(ResourceLocation overlayTexture) {
        this.overlayTexture = overlayTexture;
    }

    @Generated
    public ResourceLocation getDefaultOverlayTexture() {
        return this.defaultOverlayTexture;
    }

    @Generated
    public static ResourceLocation getDefaultBaseTexture() {
        return defaultBaseTexture;
    }
}

