/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.client.model.hatch.HatchBakedModel;
import es.degrassi.mmreborn.common.entity.base.BlockEntityRestrictedTick;
import es.degrassi.mmreborn.common.entity.base.IServerTickEntity;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.TextureableMachineEntity;
import es.degrassi.mmreborn.common.machine.MachineHatchType;
import es.degrassi.mmreborn.common.machine.component.ChunkloadComponent;
import es.degrassi.mmreborn.common.network.server.SUpdateMachineTexturePacket;
import es.degrassi.mmreborn.common.registration.EntityRegistration;
import es.degrassi.mmreborn.common.registration.MachineHatchTypeRegistration;
import es.degrassi.mmreborn.common.util.Chunkloader;
import es.degrassi.mmreborn.common.util.ChunkloaderList;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.network.PacketDistributor;

@MethodsReturnNonnullByDefault
public class ChunkloaderEntity
extends BlockEntityRestrictedTick
implements MachineComponentEntity<ChunkloadComponent>,
TextureableMachineEntity,
IServerTickEntity {
    private ResourceLocation baseTexture;
    private ResourceLocation overlayTexture;
    private static final ResourceLocation defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_chunkloader");
    private static final ResourceLocation defaultBaseTexture = ModularMachineryReborn.rl("block/casing_plain");
    private final Chunkloader chunkloader = new Chunkloader(this);
    private boolean unloaded = false;

    public ChunkloaderEntity(BlockPos pos, BlockState blockState) {
        super(EntityRegistration.CHUNKLOADER.get(), pos, blockState);
        this.overlayTexture = defaultOverlayTexture;
        this.baseTexture = defaultBaseTexture;
    }

    @Override
    public ChunkloadComponent provideComponent() {
        return new ChunkloadComponent(this);
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.saveAdditional(nbt, pRegistries);
        nbt.putString("chunkloader", this.chunkloader.toString());
        if (this.baseTexture != null) {
            nbt.putString("baseTexture", this.baseTexture.toString());
        }
        if (this.overlayTexture != null) {
            nbt.putString("overlayTexture", this.overlayTexture.toString());
        }
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.chunkloader.deserializeNBT(pRegistries, compound.getCompound("chunkloader"));
        this.baseTexture = compound.contains("baseTexture") ? ResourceLocation.parse((String)compound.getString("baseTexture")) : defaultBaseTexture;
        this.overlayTexture = compound.contains("overlayTexture") ? ResourceLocation.parse((String)compound.getString("overlayTexture")) : defaultOverlayTexture;
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        ChunkloaderList.add(this);
    }

    @Override
    public void doRestrictedTick() {
        this.chunkloader.serverTick();
    }

    public void onLoad() {
        super.onLoad();
        this.chunkloader.init();
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.unloaded = true;
    }

    public void setRemoved() {
        this.chunkloader.onRemoved();
        super.setRemoved();
    }

    public ModelData getModelData() {
        ModelData.Builder builder = this.getModelDataBuilder("all");
        builder.with(HatchBakedModel.BASE_TEXTURE, (Object)this.baseTexture).with(HatchBakedModel.BASE_TEXTURE_NAME, (Object)"bg_all");
        builder.with(HatchBakedModel.OVERLAY_TEXTURE, (Object)this.overlayTexture).with(HatchBakedModel.OVERLAY_TEXTURE_NAME, (Object)"ov_all");
        return builder.build();
    }

    @Override
    public ResourceLocation getMachineBaseTexture() {
        return this.baseTexture;
    }

    @Override
    public void setMachineBaseTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.baseTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.baseTexture, true, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public ResourceLocation getMachineOverlayTexture() {
        return this.overlayTexture;
    }

    @Override
    public void setMachineOverlayTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.overlayTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.overlayTexture, false, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public MachineHatchType getHatchType() {
        return MachineHatchTypeRegistration.BIOME_READER.get();
    }

    @Override
    public void resetTextures() {
        this.setMachineBaseTexture(defaultBaseTexture);
        this.setMachineOverlayTexture(defaultOverlayTexture);
    }

    @Generated
    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    @Generated
    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    @Generated
    public Chunkloader getChunkloader() {
        return this.chunkloader;
    }

    @Generated
    public void setBaseTexture(ResourceLocation baseTexture) {
        this.baseTexture = baseTexture;
    }

    @Generated
    public void setOverlayTexture(ResourceLocation overlayTexture) {
        this.overlayTexture = overlayTexture;
    }

    @Generated
    public void setUnloaded(boolean unloaded) {
        this.unloaded = unloaded;
    }

    @Generated
    public boolean isUnloaded() {
        return this.unloaded;
    }
}

