/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.jei;

import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementDuration;
import es.degrassi.mmreborn.common.crafting.requirement.jei.JeiComponent;
import es.degrassi.mmreborn.common.integration.jei.MMRJeiPlugin;
import es.degrassi.mmreborn.common.integration.jei.category.MMRRecipeCategory;
import es.degrassi.mmreborn.common.integration.jei.category.drawable.ProgressDrawable;
import es.degrassi.mmreborn.common.integration.jei.ingredient.CustomIngredientTypes;
import es.degrassi.mmreborn.common.machine.component.DurationComponent;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class JeiDurationComponent
extends JeiComponent<Integer, RecipeRequirement<DurationComponent, RequirementDuration>> {
    private final ProgressDrawable progress;
    private int duration;

    public JeiDurationComponent(RecipeRequirement<DurationComponent, RequirementDuration> requirement, int ticksPerCycle, IDrawableAnimated.StartDirection direction) {
        super(requirement, 0, 0);
        this.progress = new ProgressDrawable(ticksPerCycle, direction);
    }

    @Override
    public int getWidth() {
        return this.progress.getWidth();
    }

    @Override
    public int getHeight() {
        return this.progress.getHeight();
    }

    @Override
    public List<Integer> ingredients() {
        return List.of(Integer.valueOf(this.duration));
    }

    @Override
    public void render(GuiGraphics guiGraphics, @NotNull Integer ingredient) {
        this.progress.draw(guiGraphics, 0, 0);
    }

    @Override
    @NotNull
    public List<Component> getTooltip(@NotNull Integer ingredient, @NotNull TooltipFlag tooltipFlag) {
        List<Component> tooltip = super.getTooltip(ingredient, tooltipFlag);
        tooltip.add((Component)Component.translatable((String)"modular_machinery_reborn.jei.ingredient.duration", (Object[])new Object[]{this.duration}));
        return tooltip;
    }

    @Override
    public void setRecipe(MMRRecipeCategory category, IRecipeLayoutBuilder builder, MachineRecipe recipe, IFocusGroup focuses) {
        this.duration = recipe.getRecipeTotalTickTime();
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, this.getPosition().x(), this.getPosition().y()).setOverlay((IDrawable)MMRJeiPlugin.jeiHelpers.getGuiHelper().createBlankDrawable(this.getWidth(), this.getHeight()), 0, 0).setCustomRenderer(CustomIngredientTypes.INTEGER, (IIngredientRenderer)this).addIngredients(CustomIngredientTypes.INTEGER, this.ingredients());
    }
}

