/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.screen.EmiScreenManager;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.client.requirement.ChanceRendering;
import es.degrassi.mmreborn.client.requirement.FluidRendering;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementFluid;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.SlotTooltip;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.FluidComponent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class EmiFluidComponent
extends EmiComponent<FluidStack, RecipeRequirement<FluidComponent, RequirementFluid>>
implements SlotTooltip,
FluidRendering,
ChanceRendering {
    private EmiRecipe recipe;
    private int width = 16;
    private int height = 16;

    public EmiFluidComponent(RecipeRequirement<FluidComponent, RequirementFluid> requirement) {
        super(requirement, 0, 0);
    }

    @Override
    public List<FluidStack> ingredients() {
        return Collections.singletonList(((RequirementFluid)this.requirement.requirement()).required.asFluidStack());
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.width += 2;
        this.height += 2;
        super.render(guiGraphics, mouseX, mouseY);
        this.width -= 2;
        this.height -= 2;
        this.renderFluid(guiGraphics);
        this.drawChance(guiGraphics, false);
    }

    @Override
    public float getChance() {
        return this.requirement.chance();
    }

    @Override
    public IOType getActionType() {
        return ((RequirementFluid)this.requirement.requirement()).getMode();
    }

    @Override
    public List<Component> getTooltip() {
        LinkedList<Component> tooltip = new LinkedList<Component>();
        String mode = ((RequirementFluid)this.requirement.requirement()).getMode().isInput() ? "input" : "output";
        tooltip.add((Component)Component.translatable((String)("modular_machinery_reborn.jei.ingredient.fluid." + mode), (Object[])new Object[]{((RequirementFluid)this.requirement.requirement()).required.asFluidStack().getHoverName(), ((RequirementFluid)this.requirement.requirement()).required.asFluidStack().getAmount()}));
        this.addChanceTooltips(tooltip);
        return tooltip;
    }

    @Override
    public void recipeContext(EmiRecipe recipe) {
        this.recipe = recipe;
    }

    @Override
    public EmiStack getStack() {
        return EmiStack.of((Fluid)this.ingredients().get(0).getFluid(), (long)((RequirementFluid)this.requirement.requirement()).amount);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.slotInteraction(bind -> bind.matchesMouse(button))) {
            return true;
        }
        return EmiScreenManager.stackInteraction((EmiStackInteraction)new EmiStackInteraction((EmiIngredient)this.getStack(), this.getRecipe(), true), bind -> bind.matchesMouse(button));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.slotInteraction(bind -> bind.matchesKey(keyCode, scanCode))) {
            return true;
        }
        return EmiScreenManager.stackInteraction((EmiStackInteraction)new EmiStackInteraction((EmiIngredient)this.getStack(), this.getRecipe(), true), bind -> bind.matchesKey(keyCode, scanCode));
    }

    @Override
    @Generated
    public EmiRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    @Generated
    public int getWidth() {
        return this.width;
    }

    @Override
    @Generated
    public int getHeight() {
        return this.height;
    }
}

