/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.emi;

import com.google.common.collect.Lists;
import dev.emi.emi.api.stack.EmiStack;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.client.requirement.ItemRendering;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementBiome;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiComponent;
import es.degrassi.mmreborn.common.machine.component.BiomeComponent;
import es.degrassi.mmreborn.common.registration.ItemRegistration;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class EmiBiomeComponent
extends EmiComponent<ResourceLocation, RecipeRequirement<BiomeComponent, RequirementBiome>>
implements ItemRendering {
    public EmiBiomeComponent(RecipeRequirement<BiomeComponent, RequirementBiome> requirement) {
        super(requirement, 0, 0, false);
    }

    @Override
    public int getWidth() {
        return 18;
    }

    @Override
    public int getHeight() {
        return 18;
    }

    @Override
    public EmiStack getStack() {
        return EmiStack.of((ItemStack)ItemRegistration.BIOME_READER.toStack());
    }

    @Override
    public List<ResourceLocation> ingredients() {
        return Lists.newArrayList(((RequirementBiome)this.requirement.requirement()).filter().iterator());
    }

    @Override
    @Nullable
    public ResourceLocation texture() {
        return null;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.render(guiGraphics, mouseX, mouseY);
        this.drawStack(guiGraphics, 0, 0, -1);
    }

    @Override
    public List<Component> getTooltip() {
        StringBuilder biomes = new StringBuilder();
        this.ingredients().forEach(biome -> biomes.append(biome.toString()).append(","));
        int index = biomes.lastIndexOf(",");
        if (index >= biomes.length() - 1) {
            biomes.deleteCharAt(index);
        }
        return List.of(Component.translatable((String)("modular_machinery_reborn.jei.ingredient.biome." + ((RequirementBiome)this.requirement.requirement()).blacklist()), (Object[])new Object[]{biomes.toString()}));
    }
}

