/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.codec.DefaultCodecs;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.DimensionComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import java.util.List;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RequirementDimension
implements IRequirement<DimensionComponent> {
    public static final NamedCodec<RequirementDimension> CODEC = NamedCodec.record(instance -> instance.group(DefaultCodecs.RESOURCE_LOCATION.listOf().fieldOf("filter").forGetter(RequirementDimension::filter), NamedCodec.BOOL.optionalFieldOf("blacklist", false).forGetter(RequirementDimension::blacklist), PositionedRequirement.POSITION_CODEC.optionalFieldOf("position", new PositionedRequirement(0, 0)).forGetter(IRequirement::getPosition)).apply((Applicative)instance, RequirementDimension::new), "Dimension Requirement");
    private final PositionedRequirement position;
    private final List<ResourceLocation> filter;
    private final boolean blacklist;

    public RequirementDimension(List<ResourceLocation> filter, boolean blacklist, PositionedRequirement position) {
        this.filter = filter;
        this.blacklist = blacklist;
        this.position = position;
    }

    public List<ResourceLocation> filter() {
        return this.filter;
    }

    public boolean blacklist() {
        return this.blacklist;
    }

    @Override
    public RequirementType<RequirementDimension> getType() {
        return RequirementTypeRegistration.DIMENSION.get();
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentRegistration.COMPONENT_DIMENSION.get();
    }

    @Override
    public IOType getMode() {
        return IOType.INPUT;
    }

    @Override
    public boolean test(DimensionComponent component, ICraftingContext context) {
        return this.filter.contains(component.getContainerProvider()) != this.blacklist;
    }

    @Override
    public void gatherRequirements(IRequirementList<DimensionComponent> list) {
    }

    @Override
    public JsonObject asJson() {
        JsonObject json = IRequirement.super.asJson();
        json.addProperty("blacklist", Boolean.valueOf(this.blacklist));
        JsonArray array = new JsonArray();
        this.filter.stream().map(ResourceLocation::toString).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        json.add("filter", (JsonElement)array);
        return json;
    }

    @Override
    @NotNull
    public Component getMissingComponentErrorMessage(IOType ioType) {
        return Component.translatable((String)"component.missing.dimension");
    }

    @Override
    public boolean isComponentValid(DimensionComponent m, ICraftingContext context) {
        return this.getMode().equals((Object)m.getIOType());
    }

    @Override
    @Generated
    public PositionedRequirement getPosition() {
        return this.position;
    }
}

