/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.modifier;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.codec.RegistrarCodec;
import es.degrassi.mmreborn.common.crafting.modifier.AdditionRecipeModifier;
import es.degrassi.mmreborn.common.crafting.modifier.IRecipeModifier;
import es.degrassi.mmreborn.common.crafting.modifier.MultiplicationRecipeModifier;
import es.degrassi.mmreborn.common.crafting.modifier.SpeedRecipeModifier;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import java.util.List;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public abstract class RecipeModifier
implements IRecipeModifier {
    public static final NamedCodec<RecipeModifier> CODEC = NamedCodec.record(energyModifierInstance -> energyModifierInstance.group(RegistrarCodec.REQUIREMENT_NEW.fieldOf("requirement").forGetter(modifier -> modifier.requirementType), IOType.CODEC.fieldOf("mode").forGetter(modifier -> modifier.mode), IRecipeModifier.OPERATION.CODEC.fieldOf("operation").forGetter(RecipeModifier::getOperation), NamedCodec.FLOAT.fieldOf("modifier").forGetter(modifier -> Float.valueOf(modifier.modifier)), NamedCodec.FLOAT.optionalFieldOf("chance", Float.valueOf(1.0f)).forGetter(modifier -> Float.valueOf(modifier.chance)), NamedCodec.FLOAT.optionalFieldOf("max", Float.valueOf(Float.POSITIVE_INFINITY)).forGetter(modifier -> Float.valueOf(modifier.max)), NamedCodec.FLOAT.optionalFieldOf("min", Float.valueOf(Float.NEGATIVE_INFINITY)).forGetter(modifier -> Float.valueOf(modifier.min))).apply((Applicative)energyModifierInstance, (requirement, mode, operation, modifier, chance, max, min) -> {
        if (requirement == RequirementTypeRegistration.SPEED.get()) {
            return new SpeedRecipeModifier((IRecipeModifier.OPERATION)((Object)((Object)operation)), modifier.floatValue(), chance.floatValue(), max.floatValue(), min.floatValue());
        }
        return switch (operation) {
            default -> throw new MatchException(null, null);
            case IRecipeModifier.OPERATION.ADDITION -> new AdditionRecipeModifier((RequirementType<?>)requirement, (IOType)((Object)((Object)mode)), modifier.floatValue(), chance.floatValue(), max.floatValue(), min.floatValue());
            case IRecipeModifier.OPERATION.MULTIPLICATION -> new MultiplicationRecipeModifier((RequirementType<?>)requirement, (IOType)((Object)((Object)mode)), modifier.floatValue(), chance.floatValue(), max.floatValue(), min.floatValue());
        };
    }), "Recipe modifier");
    public static final List<RequirementType<?>> blacklist = Lists.newArrayList();
    public static final RandomSource RAND;
    public final RequirementType<?> requirementType;
    public final IOType mode;
    public final float modifier;
    public final float chance;
    public final float max;
    public final float min;
    public final Component tooltip;

    public static void addToBlacklist(RequirementType<?> requirementType) {
        if (blacklist.contains(requirementType)) {
            return;
        }
        blacklist.add(requirementType);
    }

    protected RecipeModifier(RequirementType<?> requirementType, IOType mode, float modifier, float chance, float max, float min) {
        this.requirementType = requirementType;
        this.mode = mode;
        this.modifier = modifier;
        this.chance = chance;
        this.max = max;
        this.min = min;
        this.tooltip = this.getDefaultTooltip();
    }

    @Override
    public boolean shouldApply(RequirementType<?> type, IOType mode) {
        return type == this.requirementType && mode == this.mode && (double)this.chance > RAND.nextDouble();
    }

    public abstract IRecipeModifier.OPERATION getOperation();

    public JsonObject asJson() {
        JsonObject json = new JsonObject();
        ResourceLocation key = ModularMachineryReborn.getRequirementRegistrar().getKey(this.requirementType);
        if (key == null) {
            key = ModularMachineryReborn.rl("speed");
        }
        json.addProperty("target", key.toString());
        json.addProperty("mode", this.mode.getSerializedName());
        json.addProperty("modifier", (Number)Float.valueOf(this.modifier));
        json.addProperty("operation", this.getOperation().toString());
        json.addProperty("chance", (Number)Float.valueOf(this.chance));
        return json;
    }

    public CompoundTag asTag() {
        CompoundTag tag = new CompoundTag();
        ResourceLocation key = ModularMachineryReborn.getRequirementRegistrar().getKey(this.requirementType);
        if (key == null) {
            key = ModularMachineryReborn.rl("speed");
        }
        tag.putString("target", key.toString());
        tag.putString("mode", this.mode.getSerializedName());
        tag.putFloat("modifier", this.modifier);
        tag.putString("operation", this.getOperation().toString());
        tag.putFloat("chance", this.chance);
        return tag;
    }

    protected String getTargetValue() {
        return ModularMachineryReborn.getRequirementRegistrar().getKey(this.requirementType).getPath();
    }

    @Generated
    public RequirementType<?> getRequirementType() {
        return this.requirementType;
    }

    @Generated
    public IOType getMode() {
        return this.mode;
    }

    @Generated
    public float getModifier() {
        return this.modifier;
    }

    @Generated
    public float getChance() {
        return this.chance;
    }

    @Generated
    public float getMax() {
        return this.max;
    }

    @Generated
    public float getMin() {
        return this.min;
    }

    @Override
    @Generated
    public Component getTooltip() {
        return this.tooltip;
    }

    static {
        RecipeModifier.addToBlacklist(RequirementTypeRegistration.DIMENSION.get());
        RecipeModifier.addToBlacklist(RequirementTypeRegistration.BIOME.get());
        RecipeModifier.addToBlacklist(RequirementTypeRegistration.WEATHER.get());
        RecipeModifier.addToBlacklist(RequirementTypeRegistration.TIME.get());
        RecipeModifier.addToBlacklist(RequirementTypeRegistration.CHUNKLOAD.get());
        RecipeModifier.addToBlacklist(RequirementTypeRegistration.FUNCTION.get());
        RAND = RandomSource.create();
    }
}

