/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.modifier;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.JsonOps;
import es.degrassi.mmreborn.api.BlockIngredient;
import es.degrassi.mmreborn.api.codec.DefaultCodecs;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.common.crafting.modifier.RecipeModifier;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public class ModifierReplacement {
    public static final NamedCodec<ModifierReplacement> CODEC = NamedCodec.record(instance -> instance.group(BlockIngredient.CODEC.fieldOf("replacement").forGetter(ModifierReplacement::getIngredient), RecipeModifier.CODEC.listOf().fieldOf("modifiers").forGetter(ModifierReplacement::getModifiers), DefaultCodecs.BLOCK_POS.fieldOf("position").forGetter(ModifierReplacement::getPosition)).apply((Applicative)instance, ModifierReplacement::new), "Modifier Replacement");
    private final BlockIngredient info;
    private final List<RecipeModifier> modifier;
    private final List<Component> description;
    private final BlockPos position;

    public ModifierReplacement(BlockIngredient info, List<RecipeModifier> modifier, BlockPos pos) {
        this.info = info;
        this.modifier = modifier;
        this.position = pos;
        this.description = Lists.newArrayList();
        this.description.add((Component)info.getNamesUnified());
        this.description.addAll(this.getModifiers().stream().map(RecipeModifier::getTooltip).toList());
    }

    public BlockIngredient getIngredient() {
        return this.info;
    }

    public List<RecipeModifier> getModifiers() {
        return Collections.unmodifiableList(this.modifier);
    }

    public List<Component> getDescriptionLines() {
        return this.description;
    }

    public List<String> getDescriptionLinesString() {
        return this.description.stream().map(Component::getString).toList();
    }

    public JsonObject asJson() {
        JsonObject json = new JsonObject();
        json.add("replacement", (JsonElement)this.info.asJson());
        JsonArray modifiers = new JsonArray();
        this.modifier.stream().map(RecipeModifier::asJson).forEach(arg_0 -> ((JsonArray)modifiers).add(arg_0));
        json.add("modifiers", (JsonElement)modifiers);
        JsonArray desc = new JsonArray();
        this.description.stream().map(Component::getString).map(arg_0 -> ((JsonOps)JsonOps.INSTANCE).createString(arg_0)).forEach(arg_0 -> ((JsonArray)desc).add(arg_0));
        json.add("description", (JsonElement)desc);
        json.add("position", (JsonElement)DefaultCodecs.BLOCK_POS.encodeStart(JsonOps.INSTANCE, this.position).getOrThrow());
        return json;
    }

    public CompoundTag asTag() {
        CompoundTag tag = new CompoundTag();
        tag.put("replacement", (Tag)this.info.asTag());
        ListTag modifiers = new ListTag();
        this.modifier.stream().map(RecipeModifier::asTag).forEach(arg_0 -> modifiers.add(arg_0));
        tag.put("modifiers", (Tag)modifiers);
        ListTag desc = new ListTag();
        this.description.stream().map(Component::getString).map(StringTag::valueOf).forEach(arg_0 -> desc.add(arg_0));
        tag.put("description", (Tag)desc);
        CompoundTag position = new CompoundTag();
        position.putInt("x", this.position.getX());
        position.putInt("y", this.position.getY());
        position.putInt("z", this.position.getZ());
        tag.put("position", (Tag)position);
        return tag;
    }

    public String getString() {
        return this.asJson().toString();
    }

    @Generated
    public BlockPos getPosition() {
        return this.position;
    }
}

