/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.widget;

import com.google.common.collect.Lists;
import es.degrassi.mmreborn.client.screen.widget.CoreActionType;
import es.degrassi.mmreborn.client.screen.widget.ItemOrIconButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class CoreActionButton
extends ItemOrIconButton {
    private final CoreActionType type;

    public CoreActionButton(int x, int y, OnPressT onPress, CoreActionType type) {
        super(x, y, type.icon(), btn -> onPress.onPress(type));
        this.type = type;
    }

    public CoreActionButton(OnPressT onPress, CoreActionType type) {
        this(0, 0, onPress, type);
    }

    @Nullable
    public Tooltip getTooltip() {
        return Tooltip.create((Component)this.type.component(Screen.hasShiftDown(), Screen.hasControlDown()));
    }

    @Override
    public List<Component> getTooltipMessage() {
        ArrayList components = Lists.newArrayList((Object[])new Component[]{this.type.component(Screen.hasShiftDown(), Screen.hasControlDown())});
        components.add(Component.translatable((String)"%s %s", (Object[])new Object[]{Component.translatable((String)"modular_machinery_reborn.controller.shift").withStyle(ChatFormatting.AQUA), this.type.component(true, false).copy().withStyle(ChatFormatting.GRAY)}));
        components.add(Component.translatable((String)"%s %s", (Object[])new Object[]{Component.translatable((String)"modular_machinery_reborn.controller.control").withStyle(ChatFormatting.AQUA), this.type.component(false, true).copy().withStyle(ChatFormatting.GRAY)}));
        return components;
    }

    public static interface OnPressT {
        public void onPress(CoreActionType var1);
    }
}

