/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.popup;

import es.degrassi.mmreborn.client.screen.popup.BasePopupScreen;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;

@ParametersAreNonnullByDefault
public abstract class PopupScreen<T extends AbstractContainerMenu>
extends BasePopupScreen<T> {
    public final BasePopupScreen<T> parent;
    private boolean dragging;
    private double dragX;
    private double dragY;

    protected PopupScreen(BasePopupScreen<T> parent, int xSize, int ySize) {
        super(parent.getMenu(), parent.getPlayerInventory(), (Component)Component.literal((String)"Popup"), xSize, ySize);
        this.parent = parent;
    }

    public void move(int movedX, int movedY) {
        this.x += movedX;
        this.y += movedY;
        this.children().forEach(c -> {
            if (c instanceof LayoutElement) {
                LayoutElement widget = (LayoutElement)c;
                widget.setPosition(widget.getX() + movedX, widget.getY() + movedY);
            }
        });
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        if ((int)Math.abs(this.dragX) >= 1 || (int)Math.abs(this.dragY) >= 1) {
            int changedX = (int)this.dragX;
            int changedY = (int)this.dragY;
            this.move(changedX, changedY);
            this.dragX -= (double)changedX;
            this.dragY -= (double)changedY;
        }
        boolean parentHasTooltip = this.parent.deferredTooltipRendering != null;
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, partialTicks);
        }
        if (!parentHasTooltip && this.parent.deferredTooltipRendering != null) {
            if (this.deferredTooltipRendering == null) {
                this.deferredTooltipRendering = this.parent.deferredTooltipRendering;
            }
            this.parent.deferredTooltipRendering = null;
        }
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PopupScreen.blankBackground(graphics, this.x, this.y, this.xSize, this.ySize);
        this.renderBg(graphics, partialTicks, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean onRenderable = false;
        for (GuiEventListener renderable : this.children()) {
            if (!renderable.mouseClicked(mouseX, mouseY, button)) continue;
            onRenderable = true;
            break;
        }
        if (onRenderable || super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isMouseOver(mouseX, mouseY) && mouseY < (double)(this.y + 20)) {
            this.dragging = true;
            return true;
        }
        this.setDragging(false);
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean onRenderable = false;
        for (GuiEventListener renderable : this.children()) {
            if (!renderable.mouseReleased(mouseX, mouseY, button)) continue;
            onRenderable = true;
            break;
        }
        this.dragging = false;
        return onRenderable || super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging) {
            this.dragX += deltaX;
            this.dragY += deltaY;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        boolean onRenderable = false;
        for (GuiEventListener renderable : this.children()) {
            if (!renderable.isMouseOver(mouseX, mouseY)) continue;
            onRenderable = true;
            break;
        }
        return onRenderable || this.parent.getPopupUnderMouse(mouseX, mouseY) == this;
    }
}

