/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.popup;

import es.degrassi.mmreborn.client.container.ControllerContainer;
import es.degrassi.mmreborn.client.screen.ControllerScreen;
import es.degrassi.mmreborn.client.screen.popup.CoreGridPopupScreen;
import es.degrassi.mmreborn.client.screen.popup.PopupScreen;
import es.degrassi.mmreborn.client.screen.widget.Icon;
import es.degrassi.mmreborn.client.screen.widget.ItemOrIconButton;
import es.degrassi.mmreborn.common.crafting.helper.CraftingStatus;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.manager.crafting.MachineProcessorCore;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

@ParametersAreNonnullByDefault
public class CorePopupScreen
extends PopupScreen<ControllerContainer> {
    private final int core;
    private boolean closeButton = false;
    private final int page;
    private final int initialXSize;
    private final Font font;
    private final StringWidget progress;

    public CorePopupScreen(ControllerScreen parent, int xSize, int ySize, int page, int core) {
        super(parent, xSize, ySize);
        this.font = Minecraft.getInstance().font;
        this.core = core;
        this.page = page;
        this.initialXSize = xSize;
        Objects.requireNonNull(this.font);
        this.progress = new StringWidget(this.initialXSize - 10, 9, (Component)Component.empty(), this.font).alignLeft();
    }

    public CorePopupScreen addCloseButton() {
        this.closeButton = true;
        return this;
    }

    @Override
    protected void init() {
        super.init();
        MachineProcessorCore core = ((MachineControllerEntity)((ControllerContainer)this.getMenu()).getEntity()).getProcessor().cores().get(this.core - 1);
        GridLayout layout = new GridLayout(this.x + 5, this.y).columnSpacing(2).rowSpacing(5);
        int cols = 2;
        GridLayout.RowHelper row = layout.createRowHelper(cols);
        row.defaultCellSetting().alignHorizontallyLeft();
        row.addChild((LayoutElement)new StringWidget(this.initialXSize - 10, 0, (Component)Component.literal((String)""), this.font), cols);
        if (this.closeButton) {
            ItemOrIconButton returnButton = new ItemOrIconButton(0, 0, Icon.BACK, btn -> {
                CoreGridPopupScreen screen = new CoreGridPopupScreen((ControllerScreen)this.parent, 220, 180).addCloseButton();
                screen.setPage(this.page);
                this.parent.closePopup(this);
                this.parent.openPopup(screen, "popup");
            }).setTooltips(new Component[]{Component.translatable((String)"mmr.gui.button.back")});
            row.addChild((LayoutElement)returnButton, cols, row.newCellSettings().alignHorizontallyRight());
        }
        this.addCoreInfo(row, core);
        layout.arrangeElements();
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    @Override
    public void containerTick() {
        MachineProcessorCore core = ((MachineControllerEntity)((ControllerContainer)this.getMenu()).getEntity()).getProcessor().cores().get(this.core - 1);
        if (core.isActive()) {
            MutableComponent status = Component.translatable((String)"gui.controller.status");
            if (core.isHasActiveRecipe()) {
                String percProgress = Utils.decimalFormatWithPercentage(Mth.clamp((float)(core.getCurrentActiveRecipeProgress() * 100.0f), (float)0.0f, (float)100.0f));
                status.append((Component)Component.translatable((String)"gui.controller.status.crafting.progress", (Object[])new Object[]{percProgress}));
            } else {
                status.append(CraftingStatus.NO_RECIPE.getUnlocMessage());
            }
            this.progress.setMessage((Component)status);
            return;
        }
        this.progress.setMessage((Component)Component.empty());
    }

    private void addCoreInfo(GridLayout.RowHelper row, MachineProcessorCore core) {
        Objects.requireNonNull(this.font);
        row.addChild((LayoutElement)new StringWidget(this.initialXSize - 10, 9, (Component)Component.translatable((String)("mmr.core.active." + core.isActive())), this.font).alignLeft(), 2, row.newCellSettings().alignHorizontallyLeft());
        Objects.requireNonNull(this.font);
        row.addChild((LayoutElement)new StringWidget(this.initialXSize - 10, 9, (Component)Component.translatable((String)"mmr.core.number", (Object[])new Object[]{core.getCore()}), this.font).alignLeft(), 2, row.newCellSettings().alignHorizontallyLeft());
        if (core.isActive()) {
            row.addChild((LayoutElement)this.progress, 2, row.newCellSettings().alignHorizontallyLeft());
        }
    }
}

