/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.popup;

import es.degrassi.mmreborn.client.container.ControllerContainer;
import es.degrassi.mmreborn.client.screen.ControllerScreen;
import es.degrassi.mmreborn.client.screen.popup.CorePopupScreen;
import es.degrassi.mmreborn.client.screen.popup.PopupScreen;
import es.degrassi.mmreborn.client.screen.widget.Icon;
import es.degrassi.mmreborn.client.screen.widget.ItemOrIconButton;
import es.degrassi.mmreborn.client.screen.widget.StringButton;
import es.degrassi.mmreborn.common.manager.crafting.MachineProcessorCore;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class CoreGridPopupScreen
extends PopupScreen<ControllerContainer> {
    private boolean closeButton = false;
    private final int initialXSize;

    public CoreGridPopupScreen(ControllerScreen parent, int xSize, int ySize) {
        super(parent, xSize, ySize);
        this.initialXSize = xSize;
    }

    public CoreGridPopupScreen addCloseButton() {
        this.closeButton = true;
        return this;
    }

    @Override
    protected void init() {
        Font font = Minecraft.getInstance().font;
        super.init();
        GridLayout layout = new GridLayout(this.x + 5, this.y).columnSpacing(2).rowSpacing(5);
        int cols = 10;
        GridLayout.RowHelper row = layout.createRowHelper(cols);
        row.defaultCellSetting().alignHorizontallyCenter();
        row.addChild((LayoutElement)new StringWidget(this.initialXSize, 0, (Component)Component.literal((String)""), font), cols);
        if (this.closeButton) {
            row.addChild((LayoutElement)new StringWidget(5, 0, (Component)Component.literal((String)""), font));
            row.addChild((LayoutElement)Button.builder((Component)Component.literal((String)"X"), b -> this.parent.closePopup(this)).bounds(0, 0, 20, 20).build(builder -> new StringButton((Button.Builder)builder, true).setTooltips(new Component[]{Component.translatable((String)"mmr.gui.button.close")})), cols - 1, row.newCellSettings().alignHorizontallyRight().paddingRight(5));
        }
        for (MachineProcessorCore core : ((ControllerContainer)this.getMenu()).getPage()) {
            row.addChild((LayoutElement)this.createCoreButton(core));
        }
        layout.arrangeElements();
        GridLayout prevLayout = layout;
        layout = new GridLayout(this.x, this.y + layout.getHeight() + 20);
        row = layout.createRowHelper(cols);
        row.defaultCellSetting().alignHorizontallyCenter();
        AtomicReference<Object> add = new AtomicReference<Object>(null);
        AtomicReference<Object> rest = new AtomicReference<Object>(null);
        rest.set(Button.builder((Component)Component.literal((String)"<"), restB -> this.updateButton((Button)add.get(), restB, false)).bounds(0, 0, 20, 20).build(builder -> new StringButton((Button.Builder)builder, true).setTooltips(new Component[]{Component.translatable((String)"mmr.gui.button.page.prev")})));
        add.set(Button.builder((Component)Component.literal((String)">"), addB -> this.updateButton(addB, (Button)rest.get(), true)).bounds(0, 0, 20, 20).build(builder -> new StringButton((Button.Builder)builder, true).setTooltips(new Component[]{Component.translatable((String)"mmr.gui.button.page.next")})));
        ((Button)rest.get()).active = this.getPage() > 1;
        ((Button)add.get()).active = this.getPage() < ((ControllerContainer)this.getMenu()).getPagesNumber();
        row.addChild((LayoutElement)new StringWidget(this.initialXSize, 0, (Component)Component.literal((String)""), font), 10);
        row.addChild((LayoutElement)((Button)rest.get()), 4, row.newCellSettings().alignHorizontallyCenter());
        row.addChild((LayoutElement)new StringWidget((Component)Component.literal((String)String.format("%s/%s", this.getPage(), ((ControllerContainer)this.getMenu()).getPagesNumber())), font), 2, row.newCellSettings().alignHorizontallyCenter().alignVerticallyMiddle());
        row.addChild((LayoutElement)((Button)add.get()), 4, row.newCellSettings().alignHorizontallyCenter());
        layout.arrangeElements();
        layout.setY(this.y + this.ySize - layout.getHeight() - 10);
        this.xSize = Math.max(this.initialXSize, Math.max(layout.width + 8, prevLayout.width + 8));
        prevLayout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    private void updateButton(Button addB, Button restB, boolean add) {
        if (add && this.getPage() < ((ControllerContainer)this.getMenu()).getPagesNumber()) {
            this.setPage(this.getPage() + 1);
        } else if (!add && this.getPage() > 1) {
            this.setPage(this.getPage() - 1);
        }
        this.rebuildWidgets();
        addB.active = this.getPage() < ((ControllerContainer)this.getMenu()).getPagesNumber();
        restB.active = this.getPage() > 1;
    }

    @NotNull
    private ItemOrIconButton createCoreButton(MachineProcessorCore core) {
        ItemOrIconButton button = new ItemOrIconButton(0, 0, core.isActive() ? Icon.CORE_ACTIVE : Icon.CORE_INACTIVE, btn -> {
            this.parent.closePopup(this);
            this.parent.openPopup(new CorePopupScreen((ControllerScreen)this.parent, 180, 96, this.getPage(), core.getCore()).addCloseButton(), "popup");
        }).renderTooltip(true).setTooltips(new Component[]{Component.translatable((String)"mmr.gui.core.button", (Object[])new Object[]{core.getCore()})});
        button.setTooltip(null);
        return button;
    }

    public int getPage() {
        return ((ControllerContainer)this.getMenu()).getCurrentCorePage();
    }

    public void setPage(int page) {
        ((ControllerContainer)this.getMenu()).setPage(page);
    }
}

