/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen;

import com.google.common.collect.Maps;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.client.container.ExperienceHatchContainer;
import es.degrassi.mmreborn.client.screen.BaseScreen;
import es.degrassi.mmreborn.client.screen.widget.ExperienceButton;
import es.degrassi.mmreborn.client.screen.widget.ExperienceButtonType;
import es.degrassi.mmreborn.client.screen.widget.ExperienceWidget;
import es.degrassi.mmreborn.common.entity.ExperienceInputHatchEntity;
import es.degrassi.mmreborn.common.entity.ExperienceOutputHatchEntity;
import es.degrassi.mmreborn.common.entity.base.ExperienceHatchEntity;
import es.degrassi.mmreborn.common.network.client.CExperienceButtonClickedPacket;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExperienceHatchScreen
extends BaseScreen<ExperienceHatchContainer, ExperienceHatchEntity> {
    private ExperienceWidget experienceWidget;
    private final Map<ExperienceButtonType, ExperienceButton> experienceButtons = Maps.newHashMap();

    public ExperienceHatchScreen(ExperienceHatchContainer menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title, false);
    }

    @Override
    @Nullable
    public ResourceLocation getTexture() {
        return ModularMachineryReborn.rl("textures/gui/guiexperience.png");
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        this.clearWidgets();
        this.experienceWidget = (ExperienceWidget)this.addRenderableWidget((GuiEventListener)new ExperienceWidget(this.getGuiLeft(), this.getGuiTop() + 20, this.imageWidth, (ExperienceHatchEntity)((ExperienceHatchContainer)this.getMenu()).getEntity()));
        AtomicInteger x = new AtomicInteger(8 + this.getGuiLeft());
        Object object = ((ExperienceHatchContainer)this.getMenu()).getEntity();
        if (object instanceof ExperienceInputHatchEntity) {
            ExperienceInputHatchEntity e = (ExperienceInputHatchEntity)object;
            for (ExperienceButtonType type : ExperienceButtonType.insertions()) {
                this.experienceButtons.put(type, new ExperienceButton(x.getAndAdd(18), 45 + this.getGuiTop(), t -> PacketDistributor.sendToServer((CustomPacketPayload)new CExperienceButtonClickedPacket(e.getBlockPos(), t, t.extract()), (CustomPacketPayload[])new CustomPacketPayload[0]), type));
                this.addRenderableWidget((GuiEventListener)this.experienceButtons.get((Object)type));
            }
            x.getAndAdd(16);
        } else {
            object = ((ExperienceHatchContainer)this.getMenu()).getEntity();
            if (object instanceof ExperienceOutputHatchEntity) {
                ExperienceOutputHatchEntity e = (ExperienceOutputHatchEntity)object;
                x.set(this.getGuiLeft() + this.imageWidth - 8 - 17);
                for (ExperienceButtonType type : ExperienceButtonType.extractions().reversed()) {
                    this.experienceButtons.put(type, new ExperienceButton(x.getAndAdd(-18), 45 + this.getGuiTop(), t -> PacketDistributor.sendToServer((CustomPacketPayload)new CExperienceButtonClickedPacket(e.getBlockPos(), t, t.extract()), (CustomPacketPayload[])new CustomPacketPayload[0]), type));
                    this.addRenderableWidget((GuiEventListener)this.experienceButtons.get((Object)type));
                }
            }
        }
        this.renderSlots(guiGraphics);
    }

    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        if (this.experienceWidget.isHovered()) {
            guiGraphics.renderTooltip(this.font, this.experienceWidget.getTooltipMessage(), x, y);
        }
        for (ExperienceButton button : this.experienceButtons.values()) {
            if (!button.isHovered()) continue;
            guiGraphics.renderTooltip(this.font, button.getTooltipMessage().stream().map(Component::getVisualOrderText).toList(), x, y);
        }
    }
}

