/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.item;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
public class MMRItemTooltip
implements ClientTooltipComponent {
    private static final ResourceLocation CHECK = ModularMachineryReborn.rl("textures/gui/check.png");
    private final ItemStack stack;
    private final Component text;
    private final boolean completed;
    private final int iconWidth;
    private final int iconHeight;
    private final int textWidth;
    private final int textHeight;
    private static final int maxTextWidth = Minecraft.getInstance().font.width("100x [#modular_machinery_reborn:energyoutputhatch]");

    public MMRItemTooltip(ItemStack stack, Component text, boolean completed) {
        this.stack = stack;
        MutableComponent tempText = Component.empty();
        if (text.getString().contains("#")) {
            tempText.append((Component)Component.literal((String)"(").withStyle(ChatFormatting.GRAY)).append((Component)stack.getHoverName().copy().withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)") ").withStyle(ChatFormatting.GRAY));
        }
        this.text = tempText.append((Component)text.copy().withStyle(completed ? ChatFormatting.GREEN : ChatFormatting.GRAY));
        this.iconWidth = TextureSizeHelper.getWidth(CHECK);
        this.iconHeight = TextureSizeHelper.getHeight(CHECK);
        this.completed = completed;
        this.textHeight = Minecraft.getInstance().font.wordWrapHeight((FormattedText)this.text, maxTextWidth);
        this.textWidth = Math.min(Minecraft.getInstance().font.width((FormattedText)this.text), maxTextWidth);
    }

    public int getHeight() {
        return Math.max(this.textHeight, 18) + 6;
    }

    public int getWidth(Font font) {
        return 24 + this.textWidth + this.iconWidth;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        if (this.completed) {
            guiGraphics.blit(CHECK, x, y, 0.0f, 0.0f, this.iconWidth, this.iconHeight, this.iconWidth, this.iconHeight);
        }
        guiGraphics.renderItem(this.stack, x += this.iconWidth + 4, y);
        guiGraphics.renderItemDecorations(font, this.stack, x, y);
        guiGraphics.drawWordWrap(font, (FormattedText)this.text, x + 16 + 4, y + 4, this.textWidth, -1);
    }
}

