/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.container;

import es.degrassi.mmreborn.client.ModularMachineryRebornClient;
import es.degrassi.mmreborn.client.container.ContainerBase;
import es.degrassi.mmreborn.client.container.SlotItemComponent;
import es.degrassi.mmreborn.common.block.prop.ItemDurabilityHatchSize;
import es.degrassi.mmreborn.common.data.MMRConfig;
import es.degrassi.mmreborn.common.entity.base.DurabilityHatchEntity;
import es.degrassi.mmreborn.common.registration.ContainerRegistration;
import es.degrassi.mmreborn.common.util.IOInventory;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;

public class ItemDurabilityContainer
extends ContainerBase<DurabilityHatchEntity> {
    public static void open(ServerPlayer player, final DurabilityHatchEntity machine) {
        player.openMenu(new MenuProvider(){

            @NotNull
            public Component getDisplayName() {
                return Component.translatable((String)"modular_machinery_reborn.gui.title.durability_hatch");
            }

            public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
                return new ItemDurabilityContainer(id, inv, machine);
            }
        }, buf -> buf.writeBlockPos(machine.getBlockPos()));
    }

    public ItemDurabilityContainer(int id, Inventory playerInv, DurabilityHatchEntity entity) {
        super(entity, playerInv.player, (MenuType)ContainerRegistration.ITEM_DURABILITY_HATCH.get(), id);
    }

    public ItemDurabilityContainer(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, ModularMachineryRebornClient.getClientSideItemDurabilityEntity(buffer.readBlockPos()));
    }

    @Override
    public void init() {
        super.init();
        this.addInventorySlots(((DurabilityHatchEntity)this.getEntity()).getInventory(), ((DurabilityHatchEntity)this.getEntity()).getSize(), new AtomicInteger(this.getFirstComponentSlotIndex()));
    }

    @Override
    protected void addPlayerSlots(AtomicInteger slotIndex) {
        int i;
        int rows = (int)Math.ceil((double)((DurabilityHatchEntity)this.getEntity()).getSlots() * 1.0 / (double)((DurabilityHatchEntity)this.getEntity()).getSize().cols);
        int yOffset = rows * 18 + 18;
        for (i = 0; i < 9; ++i) {
            this.addSyncedSlot(new Slot((Container)this.player.getInventory(), slotIndex.getAndIncrement(), 8 + i * 18, yOffset + 54 + 3));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int lastYOffset = yOffset + i * 18;
                this.addSyncedSlot(new Slot((Container)this.player.getInventory(), slotIndex.getAndIncrement(), 8 + j * 18, lastYOffset));
            }
        }
    }

    protected void addInventorySlots(IOInventory itemHandler, ItemDurabilityHatchSize size, AtomicInteger atomicInteger) {
        int xOffset = (Integer)MMRConfig.get().itemSlotXOffset.get();
        int yOffset = (Integer)MMRConfig.get().itemSlotYOffset.get();
        int cols = size.cols;
        int row = 0;
        int s = 0;
        int c = 0;
        while (s < size.slots) {
            if (c >= cols) {
                c = 0;
                ++row;
            }
            this.addSyncedSlot(new SlotItemComponent(itemHandler.getInventory().get(s), atomicInteger.getAndIncrement(), xOffset + c * 18, yOffset + row * 18));
            ++s;
            ++c;
        }
    }
}

