/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api.network;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.network.DataType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public interface IData<T> {
    public DataType<?, T> getType();

    public short getID();

    public T getValue();

    default public void writeData(RegistryFriendlyByteBuf buffer) {
        if (this.getType().getId() == null) {
            throw new IllegalStateException("Attempting to write invalid data to Modular Machine container syncing packet : " + this.getType().toString() + " is not registered !");
        }
        buffer.writeResourceLocation(this.getType().getId());
        buffer.writeShort((int)this.getID());
    }

    public static IData<?> readData(RegistryFriendlyByteBuf buffer) {
        ResourceLocation typeId = buffer.readResourceLocation();
        DataType type = (DataType)ModularMachineryReborn.dataRegistrar().get(typeId);
        if (type == null) {
            throw new IllegalStateException("Attempting to read invalid IData : " + String.valueOf(typeId) + " is not a valid registered DataType !");
        }
        short id = buffer.readShort();
        return type.readData(id, buffer);
    }
}

