/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api.crafting;

import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.crafting.modifier.RecipeModifier;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;

public class CraftingContext
implements ICraftingContext {
    private final MachineControllerEntity tile;
    private final RecipeHolder<? extends MachineRecipe> recipe;
    private final Supplier<Float> progressTimeGetter;
    private final int core;
    private float baseSpeed = 1.0f;

    public CraftingContext(MachineControllerEntity tile, RecipeHolder<? extends MachineRecipe> recipe, Supplier<Float> progressTimeGetter, int core) {
        this.tile = tile;
        this.recipe = recipe;
        this.progressTimeGetter = progressTimeGetter;
        this.core = core;
    }

    @Override
    public MachineControllerEntity getMachineTile() {
        return this.tile;
    }

    @Override
    public int getCurrentCore() {
        return this.core;
    }

    @Override
    public MachineRecipe getRecipe() {
        return (MachineRecipe)this.recipe.value();
    }

    @Override
    public ResourceLocation getRecipeId() {
        return this.recipe.id();
    }

    @Override
    public float getRemainingTime() {
        if (this.getRecipe() == null) {
            return 0.0f;
        }
        return (float)this.getRecipe().getRecipeTotalTickTime() - this.progressTimeGetter.get().floatValue();
    }

    @Override
    public float getBaseSpeed() {
        return this.baseSpeed;
    }

    @Override
    public void setBaseSpeed(float baseSpeed) {
        this.baseSpeed = baseSpeed;
    }

    @Override
    public float getModifiedSpeed() {
        if (this.getRecipe() == null) {
            return this.baseSpeed;
        }
        int baseTime = this.getRecipe().getRecipeTotalTickTime();
        float modifiedTime = this.getModifiedValue(baseTime, RequirementTypeRegistration.SPEED.get(), IOType.INPUT);
        float speed = (float)baseTime * this.baseSpeed / modifiedTime;
        return Math.max(0.01f, speed);
    }

    @Override
    public long getIntegerModifiedValue(float value, IRequirement<?> requirement) {
        return Math.round(this.getModifiedValue(value, requirement));
    }

    @Override
    public long getPerTickIntegerModifiedValue(float value, IRequirement<?> requirement) {
        return Math.round(this.getPerTickModifiedValue(value, requirement));
    }

    @Override
    public List<RecipeModifier> getModifiers(RequirementType<?> target) {
        return this.tile.getComponentManager().getModifiers(target);
    }

    @Override
    public float getModifiedValue(float value, IRequirement<?> requirement) {
        return this.getModifiedValue(value, requirement.getType(), requirement.getMode());
    }

    @Override
    public float getPerTickModifiedValue(float value, IRequirement<?> requirement) {
        if (this.getRemainingTime() > 0.0f) {
            return this.getModifiedValue(value, requirement) * Math.min(this.getModifiedSpeed(), this.getRemainingTime());
        }
        return this.getModifiedValue(value, requirement) * this.getModifiedSpeed();
    }

    private float getModifiedValue(float value, RequirementType<?> type, IOType mode) {
        float modified = value;
        List<RecipeModifier> modifiers = this.tile.getComponentManager().getModifiers(type);
        for (RecipeModifier modifier : modifiers) {
            if (!modifier.shouldApply(type, mode)) continue;
            modified = modifier.apply(modified);
        }
        return modified;
    }

    public static class Mutable
    extends CraftingContext {
        private MachineRecipe recipe;
        private ResourceLocation recipeId;

        public Mutable(MachineControllerEntity tile, int core) {
            super(tile, null, () -> Float.valueOf(0.0f), core);
        }

        public Mutable setRecipe(MachineRecipe recipe, ResourceLocation recipeId) {
            this.recipe = recipe;
            this.recipeId = recipeId;
            return this;
        }

        @Override
        public MachineRecipe getRecipe() {
            return this.recipe;
        }

        @Override
        public ResourceLocation getRecipeId() {
            return this.recipeId;
        }
    }
}

