/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.ListBuilder;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.common.util.MMRLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class EnhancedListCodec<A>
implements NamedCodec<List<A>> {
    private final NamedCodec<A> elementCodec;
    private final String name;

    public static <A> EnhancedListCodec<A> of(NamedCodec<A> elementCodec) {
        return EnhancedListCodec.of(elementCodec, "List<" + elementCodec.name() + ">");
    }

    public static <A> EnhancedListCodec<A> of(NamedCodec<A> elementCodec, String name) {
        return new EnhancedListCodec<A>(elementCodec, name);
    }

    private EnhancedListCodec(NamedCodec<A> elementCodec, String name) {
        this.elementCodec = elementCodec;
        this.name = name;
    }

    @Override
    public <T> DataResult<T> encode(DynamicOps<T> ops, List<A> input, T prefix) {
        ListBuilder builder = ops.listBuilder();
        for (A a : input) {
            builder.add(this.elementCodec.encodeStart(ops, a));
        }
        return builder.build(prefix);
    }

    @Override
    public <T> DataResult<Pair<List<A>, T>> decode(DynamicOps<T> ops, T input) {
        if (ops.getStream(input).error().isPresent()) {
            return this.elementCodec.decode(ops, input).map(pair -> Pair.of(Collections.singletonList(pair.getFirst()), (Object)pair.getSecond()));
        }
        DataResult streamResult = ops.getStream(input);
        if (streamResult.result().isPresent()) {
            Stream stream = (Stream)streamResult.result().get();
            ArrayList result = new ArrayList();
            stream.forEach(t -> {
                DataResult<A> a = this.elementCodec.read(ops, t);
                if (a.result().isPresent()) {
                    result.add(a.result().get());
                } else if (a.error().isPresent()) {
                    MMRLogger.INSTANCE.warn("Error when parsing {} in list.\n{}", (Object)this.elementCodec.name(), (Object)((DataResult.Error)a.error().get()).message());
                }
            });
            return DataResult.success((Object)Pair.of(result, (Object)ops.empty()));
        }
        return streamResult.map(s -> Pair.of(Collections.emptyList(), (Object)input));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnhancedListCodec listCodec = (EnhancedListCodec)o;
        return Objects.equals(this.elementCodec, listCodec.elementCodec);
    }

    public int hashCode() {
        return Objects.hash(this.elementCodec);
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

