/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.blockentity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.wrappers.BlockWrapper;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.fluid.Tank;
import org.cyclops.flopper.FlopperNeoForge;
import org.cyclops.flopper.block.BlockFlopperConfig;
import org.cyclops.flopper.blockentity.BlockEntityFlopper;
import org.cyclops.flopper.blockentity.FluidHandlerBlockNeoForge;

public class BlockEntityFlopperNeoForge
extends BlockEntityFlopper {
    private Tank tank = new SingleUseTank(BlockFlopperConfig.capacityMb){

        protected void sendUpdate() {
            super.sendUpdate();
            BlockEntityFlopperNeoForge.this.sendUpdate();
            BlockEntityFlopperNeoForge.this.onDirty();
        }
    };

    public BlockEntityFlopperNeoForge(BlockPos blockPos, BlockState blockState) {
        super(blockPos, blockState);
    }

    public Tank getTank() {
        return this.tank;
    }

    public void read(CompoundTag tag, HolderLookup.Provider provider) {
        super.read(tag, provider);
        this.tank.readFromNBT(provider, tag.getCompound("tank"));
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        CompoundTag tagTank = new CompoundTag();
        this.tank.writeToNBT(provider, tagTank);
        tag.put("tank", (Tag)tagTank);
    }

    @Override
    protected boolean pushFluidsToTank() {
        Direction targetSide = this.getFacing().getOpposite();
        BlockPos targetPos = this.getBlockPos().relative(this.getFacing());
        return FlopperNeoForge._instance.getModHelpers().getCapabilityHelpers().getCapability((ILevelExtension)this.level, targetPos, (Object)targetSide, Capabilities.FluidHandler.BLOCK).map(fluidHandler -> !FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)this.tank, (int)BlockFlopperConfig.pushFluidRate, (boolean)true).isEmpty()).orElse(false);
    }

    @Override
    protected boolean pullFluidsFromTank() {
        BlockPos targetPos = this.getBlockPos().relative(Direction.UP);
        return FlopperNeoForge._instance.getModHelpers().getCapabilityHelpers().getCapability((ILevelExtension)this.level, targetPos, (Object)Direction.DOWN, Capabilities.FluidHandler.BLOCK).map(fluidHandler -> !FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)fluidHandler, (int)BlockFlopperConfig.pullFluidRate, (boolean)true).isEmpty()).orElse(false);
    }

    @Override
    protected boolean pushFluidsToWorld() {
        boolean isDestReplaceable;
        BlockPos targetPos = this.getBlockPos().relative(this.getFacing());
        BlockState destBlockState = this.level.getBlockState(targetPos);
        boolean isDestNonSolid = !destBlockState.isSolid();
        boolean bl = isDestReplaceable = destBlockState.getPistonPushReaction() == PushReaction.DESTROY;
        if (this.level.isEmptyBlock(targetPos) || isDestNonSolid && isDestReplaceable && !destBlockState.liquid()) {
            FluidStack fluidStack = this.tank.getFluid();
            if (!this.level.dimensionType().ultraWarm() || !fluidStack.getFluid().getFluidType().isVaporizedOnPlacement(this.level, this.worldPosition, fluidStack)) {
                return this.getFluidBlockHandler(fluidStack.getFluid(), this.level, targetPos).map(fluidHandler -> {
                    FluidStack moved = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)this.tank, (int)Integer.MAX_VALUE, (boolean)true);
                    if (!moved.isEmpty()) {
                        SoundEvent soundevent;
                        if (BlockFlopperConfig.worldPullPushSounds && (soundevent = moved.getFluid().getFluidType().getSound(SoundActions.BUCKET_FILL)) != null) {
                            this.level.playSound(null, this.worldPosition, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                        if (BlockFlopperConfig.worldPullPushNeighbourEvents) {
                            this.level.neighborChanged(this.worldPosition, Blocks.AIR, this.worldPosition);
                        }
                        return true;
                    }
                    return false;
                }).orElse(false);
            }
        }
        return false;
    }

    private Optional<IFluidHandler> getFluidBlockHandler(Fluid fluid, Level world, BlockPos targetPos) {
        if (!fluid.getFluidType().canBePlacedInLevel((BlockAndTintGetter)world, targetPos, fluid.defaultFluidState())) {
            return Optional.empty();
        }
        BlockState state = fluid.getFluidType().getBlockForFluidState((BlockAndTintGetter)world, targetPos, fluid.defaultFluidState());
        return Optional.of(new BlockWrapper(state, world, targetPos));
    }

    @Override
    protected boolean pullFluidsFromWorld() {
        BlockPos targetPos = this.getBlockPos().relative(Direction.UP);
        BlockState destBlockState = this.level.getBlockState(targetPos);
        return this.wrapFluidBlock(destBlockState, this.level, targetPos).map(fluidHandler -> {
            FluidStack moved = FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, (boolean)true);
            if (!moved.isEmpty()) {
                SoundEvent soundevent;
                if (BlockFlopperConfig.worldPullPushSounds && (soundevent = moved.getFluid().getFluidType().getSound(SoundActions.BUCKET_EMPTY)) != null) {
                    this.level.playSound(null, this.worldPosition, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (BlockFlopperConfig.worldPullPushNeighbourEvents) {
                    this.level.neighborChanged(this.worldPosition, Blocks.AIR, this.worldPosition);
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    @Override
    protected boolean isTankEmpty() {
        return this.getTank().isEmpty();
    }

    @Override
    protected boolean isTankFull() {
        return this.getTank().isFull();
    }

    @Override
    public int getFluidAmount() {
        return this.getTank().getFluidAmount();
    }

    @Override
    public int getFluidCapacity() {
        return this.getTank().getCapacity();
    }

    private Optional<IFluidHandler> wrapFluidBlock(BlockState blockState, Level world, BlockPos targetPos) {
        if (blockState.getBlock() instanceof LiquidBlock || blockState.getBlock() instanceof SimpleWaterloggedBlock) {
            return Optional.of(new FluidHandlerBlockNeoForge(blockState, world, targetPos));
        }
        return Optional.empty();
    }
}

