/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntityCommon;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.flopper.RegistryEntries;
import org.cyclops.flopper.block.BlockFlopper;
import org.cyclops.flopper.block.BlockFlopperConfig;

public abstract class BlockEntityFlopper
extends CyclopsBlockEntityCommon {
    @NBTPersist
    private int transferCooldown = -1;

    public BlockEntityFlopper(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_FLOPPER.value(), blockPos, blockState);
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    public int getTransferCooldown() {
        return this.transferCooldown;
    }

    protected Direction getFacing() {
        return (Direction)this.getLevel().getBlockState(this.getBlockPos()).getValue((Property)BlockFlopper.FACING);
    }

    protected abstract boolean pushFluidsToTank();

    protected abstract boolean pullFluidsFromTank();

    protected abstract boolean pushFluidsToWorld();

    protected abstract boolean pullFluidsFromWorld();

    protected abstract boolean isTankEmpty();

    protected abstract boolean isTankFull();

    public abstract int getFluidAmount();

    public abstract int getFluidCapacity();

    public static class Ticker
    extends BlockEntityTickerDelayed<BlockEntityFlopper> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityFlopper blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            if (level != null && !level.isClientSide) {
                blockEntity.setTransferCooldown(blockEntity.getTransferCooldown() - 1);
                if (!this.isOnTransferCooldown(blockEntity)) {
                    blockEntity.setTransferCooldown(0);
                    this.updateHopper(level, pos, blockState, blockEntity);
                }
            }
        }

        private boolean isOnTransferCooldown(BlockEntityFlopper blockEntity) {
            return blockEntity.getTransferCooldown() > 0;
        }

        protected boolean updateHopper(Level level, BlockPos pos, BlockState blockState, BlockEntityFlopper blockEntity) {
            if (level != null && !level.isClientSide) {
                if (!this.isOnTransferCooldown(blockEntity) && ((Boolean)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(blockState, (Property)BlockFlopper.ENABLED, (Comparable)Boolean.valueOf(false))).booleanValue()) {
                    boolean worked = false;
                    boolean workedWorld = false;
                    if (!blockEntity.isTankEmpty()) {
                        boolean bl = BlockFlopperConfig.pushFluidRate > 0 && blockEntity.pushFluidsToTank() || (workedWorld = BlockFlopperConfig.pushFluidsWorld && blockEntity.pushFluidsToWorld()) ? true : (worked = false);
                    }
                    if (!blockEntity.isTankFull()) {
                        boolean bl = BlockFlopperConfig.pullFluidRate > 0 && blockEntity.pullFluidsFromTank() || (workedWorld = BlockFlopperConfig.pullFluidsWorld && blockEntity.pullFluidsFromWorld() || workedWorld) || worked ? true : (worked = false);
                    }
                    if (worked) {
                        blockEntity.setTransferCooldown(workedWorld ? BlockFlopperConfig.workWorldCooldown : BlockFlopperConfig.workCooldown);
                        blockEntity.setChanged();
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
    }
}

