/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.defaultworldtype.mixin;

import de.melanx.defaultworldtype.ClientConfig;
import de.melanx.defaultworldtype.DefaultWorldType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.PresetFlatWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldCreationUiState.class})
public abstract class WorldCreationUiStateMixin {
    @Inject(method={"updatePresetLists"}, at={@At(value="TAIL")})
    private void afterUpdatePresetLists(CallbackInfo ci) {
        WorldCreationUiState state = (WorldCreationUiState)this;
        Registry worldPresets = state.getSettings().worldgenLoadContext().registryOrThrow(Registries.WORLD_PRESET);
        Registry biomes = state.getSettings().worldgenLoadContext().registryOrThrow(Registries.BIOME);
        WorldCreationUiStateMixin.defaultWorldType$writeRegistryToFile(worldPresets, "world-presets");
        WorldCreationUiStateMixin.defaultWorldType$writeRegistryToFile(biomes, "biomes");
        List<WorldCreationUiState.WorldTypeEntry> preferredPresets = WorldCreationUiStateMixin.defaultWorldType$buildPreferredPresetEntries((Registry<WorldPreset>)worldPresets);
        if (!preferredPresets.isEmpty()) {
            state.normalPresetList.clear();
            state.normalPresetList.addAll(preferredPresets);
        }
        WorldCreationUiStateMixin.defaultWorldType$selectInitialWorldType(state);
        if (ClientConfig.getKey() == WorldPresets.FLAT) {
            WorldCreationUiStateMixin.defaultWorldType$setFlatSettings(state);
        }
        if (ClientConfig.getKey() == WorldPresets.SINGLE_BIOME_SURFACE) {
            WorldCreationUiStateMixin.defaultWorldType$setSingleBiome(state);
        }
    }

    @Unique
    private static void defaultWorldType$writeRegistryToFile(Registry<?> registry, String registryName) {
        List<ResourceLocation> ids = registry.entrySet().stream().map(Map.Entry::getKey).map(ResourceKey::location).sorted().toList();
        String content = ids.size() + " possible " + registryName + " found:\n" + ids.stream().map(loc -> "- \"" + String.valueOf(loc) + "\"").collect(Collectors.joining("\n"));
        try {
            Files.writeString(ClientConfig.CONFIG_PATH.resolve(registryName + ".txt"), (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException ex) {
            DefaultWorldType.LOGGER.error("Couldn't generate file with existing {}", (Object)registryName, (Object)ex);
        }
    }

    @Unique
    private static List<WorldCreationUiState.WorldTypeEntry> defaultWorldType$buildPreferredPresetEntries(Registry<WorldPreset> registry) {
        ArrayList<WorldCreationUiState.WorldTypeEntry> result = new ArrayList<WorldCreationUiState.WorldTypeEntry>();
        for (String s : (List)ClientConfig.allowedWorldTypes.get()) {
            ResourceLocation id = ResourceLocation.parse((String)s);
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.WORLD_PRESET, (ResourceLocation)id);
            registry.getHolder(key).ifPresentOrElse(holder -> result.add(new WorldCreationUiState.WorldTypeEntry((Holder)holder)), () -> DefaultWorldType.LOGGER.warn("World preset \"{}\" not found", (Object)id));
        }
        return result;
    }

    @Unique
    private static void defaultWorldType$selectInitialWorldType(WorldCreationUiState state) {
        Optional<ResourceKey<WorldPreset>> configuredKey = Optional.of(ClientConfig.getKey());
        WorldCreationUiState.WorldTypeEntry entry = WorldCreationUiState.findPreset((WorldCreationContext)state.getSettings(), configuredKey).map(WorldCreationUiState.WorldTypeEntry::new).orElse((WorldCreationUiState.WorldTypeEntry)state.normalPresetList.getFirst());
        state.setWorldType(entry);
    }

    @Unique
    private static void defaultWorldType$setFlatSettings(WorldCreationUiState state) {
        state.updateDimensions((registry, worldDimensions) -> {
            WorldCreationContext settings = state.getSettings();
            HolderLookup.RegistryLookup block = settings.worldgenLoadContext().lookupOrThrow(Registries.BLOCK);
            HolderLookup.RegistryLookup biome = settings.worldgenLoadContext().lookupOrThrow(Registries.BIOME);
            HolderLookup.RegistryLookup structureSet = settings.worldgenLoadContext().lookupOrThrow(Registries.STRUCTURE_SET);
            HolderLookup.RegistryLookup placedFeature = settings.worldgenLoadContext().lookupOrThrow(Registries.PLACED_FEATURE);
            FlatLevelSource flatLevelSource = new FlatLevelSource(PresetFlatWorldScreen.fromString((HolderGetter)block, (HolderGetter)biome, (HolderGetter)structureSet, (HolderGetter)placedFeature, (String)((String)ClientConfig.flatMapSettings.get()), (FlatLevelGeneratorSettings)FlatLevelGeneratorSettings.getDefault((HolderGetter)biome, (HolderGetter)structureSet, (HolderGetter)placedFeature)));
            return worldDimensions.replaceOverworldGenerator((RegistryAccess)registry, (ChunkGenerator)flatLevelSource);
        });
    }

    @Unique
    private static void defaultWorldType$setSingleBiome(WorldCreationUiState state) {
        state.updateDimensions((registry, worldDimensions) -> {
            WorldCreationContext settings = state.getSettings();
            Registry biomes = settings.worldgenLoadContext().registryOrThrow(Registries.BIOME);
            Registry noiseGeneratorSettings = settings.worldgenLoadContext().registryOrThrow(Registries.NOISE_SETTINGS);
            Holder.Reference biomeReference = biomes.getHolder(ClientConfig.getFixedBiome()).orElseGet(() -> biomes.getHolderOrThrow(Biomes.PLAINS));
            FixedBiomeSource fixedBiomeSource = new FixedBiomeSource((Holder)biomeReference);
            NoiseBasedChunkGenerator noiseBasedChunkGenerator = new NoiseBasedChunkGenerator((BiomeSource)fixedBiomeSource, (Holder)noiseGeneratorSettings.getHolderOrThrow(NoiseGeneratorSettings.OVERWORLD));
            return worldDimensions.replaceOverworldGenerator((RegistryAccess)registry, (ChunkGenerator)noiseBasedChunkGenerator);
        });
    }
}

