/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.defaultworldtype;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ClientConfig {
    public static final Path CONFIG_PATH;
    public static final ClientConfig CLIENT;
    public static final ModConfigSpec CLIENT_SPEC;
    private static ModConfigSpec.ConfigValue<String> worldTypeName;
    public static ModConfigSpec.ConfigValue<String> flatMapSettings;
    private static ModConfigSpec.ConfigValue<String> singleBiome;
    public static ModConfigSpec.BooleanValue disablePresetSelectionButton;
    public static ModConfigSpec.ConfigValue<List<? extends String>> allowedWorldTypes;

    ClientConfig(ModConfigSpec.Builder builder) {
        builder.push("world-preset");
        worldTypeName = builder.comment("Type in the name from the world type which should be selected by default.").define("world-preset", (Object)"minecraft:normal", String.class::isInstance);
        flatMapSettings = builder.comment(new String[]{"Type in a valid generation setting for flat world type.", "Only works if world-type is 'minecraft:flat'."}).define("flat-settings", (Object)"minecraft:bedrock,2*minecraft:dirt,minecraft:grass_block;minecraft:plains", String.class::isInstance);
        singleBiome = builder.comment(new String[]{"Type in a valid biome for single biome world type.", "Only works if world-type is 'minecraft:single_biome_surface'."}).define("single-biome-biome", (Object)"minecraft:plains", String.class::isInstance);
        disablePresetSelectionButton = builder.comment("Disables the preset selection button in the world selection screen.").define("disable-button", false);
        allowedWorldTypes = builder.comment("The list of world types which should be available in the world selection screen. If empty, all world types are available.").defineList("allowed-world-types", List.of(), () -> "", String.class::isInstance);
        builder.pop();
    }

    public static ResourceKey<WorldPreset> getKey() {
        ResourceLocation location = ResourceLocation.tryParse((String)((String)worldTypeName.get()));
        return ResourceKey.create((ResourceKey)Registries.WORLD_PRESET, (ResourceLocation)(location == null ? ResourceLocation.withDefaultNamespace((String)"normal") : location));
    }

    public static ResourceLocation getFixedBiome() {
        return ResourceLocation.tryParse((String)((String)singleBiome.get()));
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ModConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        CONFIG_PATH = Paths.get(FMLPaths.CONFIGDIR.get().toAbsolutePath().toString(), "defaultworldtype");
    }
}

