/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.integration;

import appeng.api.config.Actionable;
import appeng.api.features.GridLinkables;
import appeng.api.features.IGridLinkableHandler;
import appeng.api.implementations.blockentities.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.setup.Registration;
import com.direwolf20.buildinggadgets2.util.BuildingUtils;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;

public class AE2Methods {
    public static final IGridLinkableHandler LINKABLE_HANDLER = new LinkableHandler();

    public static void registerItems() {
        GridLinkables.register((ItemLike)((ItemLike)Registration.Building_Gadget.get()), (IGridLinkableHandler)LINKABLE_HANDLER);
        GridLinkables.register((ItemLike)((ItemLike)Registration.Exchanging_Gadget.get()), (IGridLinkableHandler)LINKABLE_HANDLER);
        GridLinkables.register((ItemLike)((ItemLike)Registration.CopyPaste_Gadget.get()), (IGridLinkableHandler)LINKABLE_HANDLER);
    }

    public static void checkAE2ForItems(GlobalPos boundInventory, Player player, List<ItemStack> testArray, boolean simulate) {
        Level level = BuildingUtils.getLevel(player.getServer(), boundInventory);
        if (level == null) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(boundInventory.pos());
        if (blockEntity == null) {
            return;
        }
        if (blockEntity instanceof IWirelessAccessPoint) {
            IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)blockEntity;
            IGrid grid = accessPoint.getGrid();
            if (grid == null) {
                return;
            }
            MEStorage networkInv = grid.getStorageService().getInventory();
            Iterator<ItemStack> iterator = testArray.iterator();
            while (iterator.hasNext()) {
                ItemStack itemStack = iterator.next();
                AEItemKey itemKey = AEItemKey.of((ItemStack)itemStack);
                long amountExtracted = networkInv.extract((AEKey)itemKey, (long)itemStack.getCount(), Actionable.SIMULATE, IActionSource.ofPlayer((Player)player));
                if (amountExtracted != (long)itemStack.getCount()) continue;
                if (!simulate) {
                    networkInv.extract((AEKey)itemKey, (long)itemStack.getCount(), Actionable.MODULATE, IActionSource.ofPlayer((Player)player));
                }
                iterator.remove();
            }
        }
    }

    public static void checkAE2ForFluids(GlobalPos boundInventory, Player player, FluidStack fluidStack, boolean simulate) {
        Level level = BuildingUtils.getLevel(player.getServer(), boundInventory);
        if (level == null) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(boundInventory.pos());
        if (blockEntity == null) {
            return;
        }
        if (blockEntity instanceof IWirelessAccessPoint) {
            AEFluidKey fluidKey;
            IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)blockEntity;
            IGrid grid = accessPoint.getGrid();
            if (grid == null) {
                return;
            }
            MEStorage networkInv = grid.getStorageService().getInventory();
            long amountExtracted = networkInv.extract((AEKey)(fluidKey = AEFluidKey.of((FluidStack)fluidStack)), (long)fluidStack.getAmount(), Actionable.SIMULATE, IActionSource.ofPlayer((Player)player));
            if (amountExtracted == (long)fluidStack.getAmount()) {
                if (!simulate) {
                    networkInv.extract((AEKey)fluidKey, (long)fluidStack.getAmount(), Actionable.MODULATE, IActionSource.ofPlayer((Player)player));
                }
                fluidStack.shrink(fluidStack.getAmount());
            }
        }
    }

    public static void insertIntoAE2(Player player, GlobalPos boundInventory, ItemStack tempReturnedItem) {
        Level level = BuildingUtils.getLevel(player.getServer(), boundInventory);
        if (level == null) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(boundInventory.pos());
        if (blockEntity == null) {
            return;
        }
        if (blockEntity instanceof IWirelessAccessPoint) {
            IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)blockEntity;
            IGrid grid = accessPoint.getGrid();
            if (grid == null) {
                return;
            }
            MEStorage networkInv = grid.getStorageService().getInventory();
            AEItemKey itemKey = AEItemKey.of((ItemStack)tempReturnedItem);
            long amountInserted = networkInv.insert((AEKey)itemKey, (long)tempReturnedItem.getCount(), Actionable.MODULATE, IActionSource.ofPlayer((Player)player));
            tempReturnedItem.shrink((int)amountInserted);
        }
    }

    public static void insertFluidIntoAE2(Player player, GlobalPos boundInventory, FluidStack returnedFluid) {
        Level level = BuildingUtils.getLevel(player.getServer(), boundInventory);
        if (level == null) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(boundInventory.pos());
        if (blockEntity == null) {
            return;
        }
        if (blockEntity instanceof IWirelessAccessPoint) {
            AEFluidKey fluidKey;
            IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)blockEntity;
            IGrid grid = accessPoint.getGrid();
            if (grid == null) {
                return;
            }
            MEStorage networkInv = grid.getStorageService().getInventory();
            long amountInserted = networkInv.insert((AEKey)(fluidKey = AEFluidKey.of((FluidStack)returnedFluid)), (long)returnedFluid.getAmount(), Actionable.SIMULATE, IActionSource.ofPlayer((Player)player));
            if (amountInserted == (long)returnedFluid.getAmount()) {
                networkInv.insert((AEKey)fluidKey, (long)returnedFluid.getAmount(), Actionable.MODULATE, IActionSource.ofPlayer((Player)player));
                returnedFluid.shrink(returnedFluid.getAmount());
            }
        }
    }

    public static class LinkableHandler
    implements IGridLinkableHandler {
        public boolean canLink(ItemStack stack) {
            return stack.getItem() instanceof BaseGadget;
        }

        public void link(ItemStack itemStack, GlobalPos pos) {
            GadgetNBT.setBoundPos(itemStack, pos);
        }

        public void unlink(ItemStack itemStack) {
            GadgetNBT.clearBoundPos(itemStack);
        }
    }
}

