/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.tiab_charger.block.entity;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.tiab_charger.block.TIABChargerBlocks;
import com.benbenlaw.tiab_charger.block.entity.TIABChargerBlockEntities;
import com.benbenlaw.tiab_charger.config.StartupConfig;
import com.benbenlaw.tiab_charger.screen.TIABChargerMenu;
import com.benbenlaw.tiab_charger.util.ModEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mangorage.tiab.common.api.impl.ITiabItem;

public class TIABChargerBlockEntity
extends SyncableBlockEntity
implements MenuProvider {
    public final ContainerData data;
    private static final int ENERGY_PER_CHARGE = (Integer)StartupConfig.rfPerCharge.get();
    private static final int SECONDS_PER_CHARGE = (Integer)StartupConfig.secondsPerCharge.get();
    public final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TIABChargerBlockEntity.this.setChanged();
        }
    };
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();

    public TIABChargerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TIABChargerBlockEntities.TIAB_CHARGER_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(this){

            public int get(int index) {
                return 0;
            }

            public void set(int index, int value) {
            }

            public int getCount() {
                return 1;
            }
        };
    }

    private ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(10000000, 100000){

            @Override
            public void onEnergyChanged() {
                TIABChargerBlockEntity.this.setChanged();
                TIABChargerBlockEntity.this.getLevel().sendBlockUpdated(TIABChargerBlockEntity.this.getBlockPos(), TIABChargerBlockEntity.this.getBlockState(), TIABChargerBlockEntity.this.getBlockState(), 3);
            }
        };
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public Component getDisplayName() {
        return ((Block)TIABChargerBlocks.TIAB_CHARGER.get()).getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new TIABChargerMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void tick() {
        if (!this.level.isClientSide()) {
            this.sync();
            Item item = this.itemHandler.getStackInSlot(0).getItem();
            if (item instanceof ITiabItem) {
                ITiabItem tiab = (ITiabItem)item;
                int totalEnergyRequired = ENERGY_PER_CHARGE;
                if (this.ENERGY_STORAGE.getEnergyStored() >= totalEnergyRequired) {
                    this.ENERGY_STORAGE.extractEnergy(totalEnergyRequired, false);
                    for (int i = 0; i < SECONDS_PER_CHARGE; ++i) {
                        tiab.tickBottle(this.itemHandler.getStackInSlot(0));
                    }
                }
            }
        }
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        return this.ENERGY_STORAGE;
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.putInt("energy", this.ENERGY_STORAGE.getEnergyStored());
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.ENERGY_STORAGE.setEnergy(compoundTag.getInt("energy"));
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }
}

