/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.tiab_charger.block;

import com.benbenlaw.tiab_charger.block.entity.TIABChargerBlockEntities;
import com.benbenlaw.tiab_charger.block.entity.TIABChargerBlockEntity;
import com.benbenlaw.tiab_charger.screen.TIABChargerMenu;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TIABChargerBlock
extends BaseEntityBlock {
    public static final MapCodec<TIABChargerBlock> CODEC = TIABChargerBlock.simpleCodec(TIABChargerBlock::new);

    protected TIABChargerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (!level.isClientSide()) {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof TIABChargerBlockEntity) {
                TIABChargerBlockEntity clocheBlockEntity = (TIABChargerBlockEntity)blockEntity;
                ContainerData data = clocheBlockEntity.data;
                player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new TIABChargerMenu(windowId, playerInventory, blockPos, data), (Component)Component.translatable((String)"block.tiab_charger.tiab_charger_menu")), buf -> buf.writeBlockPos(blockPos));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void onRemove(BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState newBlockState, boolean isMoving) {
        BlockEntity blockEntity;
        if (blockState.getBlock() != newBlockState.getBlock() && (blockEntity = level.getBlockEntity(blockPos)) instanceof TIABChargerBlockEntity) {
            ((TIABChargerBlockEntity)blockEntity).drops();
        }
        super.onRemove(blockState, level, blockPos, newBlockState, isMoving);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TIABChargerBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return TIABChargerBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)TIABChargerBlockEntities.TIAB_CHARGER_BLOCK_ENTITY.get()), (world, blockPos, thisBlockState, blockEntity) -> blockEntity.tick());
    }
}

