/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.smartcrafting.screen;

import com.benbenlaw.smartcrafting.networking.packets.SyncFavoriteRecipes;
import com.benbenlaw.smartcrafting.networking.packets.SyncSortType;
import com.benbenlaw.smartcrafting.networking.payload.SmartCraftingRecipeClickPayload;
import com.benbenlaw.smartcrafting.screen.SmartCraftingMenu;
import com.benbenlaw.smartcrafting.screen.SortType;
import com.benbenlaw.smartcrafting.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;

public class SmartCraftingScreen
extends AbstractContainerScreen<SmartCraftingMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"smartcrafting", (String)"textures/gui/smart_crafting_table.png");
    private static final int TOOLTIP_SIZE = 62;
    private static final ResourceLocation CRAFTING_TOOLTIP_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"smartcrafting", (String)"textures/gui/smart_crafting_table_render.png");
    private static final ResourceLocation STONECUTTER_TOOLTIP_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"smartcrafting", (String)"textures/gui/smart_crafting_table_stonecutter_render.png");
    static final ResourceLocation SCROLL_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"smartcrafting", (String)"textures/gui/scroll.png");
    static final ResourceLocation MODE_BUTTON_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"smartcrafting", (String)"textures/gui/mode_button.png");
    static final ResourceLocation STAR_ICON = ResourceLocation.fromNamespaceAndPath((String)"smartcrafting", (String)"textures/gui/favorite.png");
    public static final String FAVORITES_TAG = "smart_crafting_favorites";
    private List<RecipeHolder<?>> clientRecipes = Collections.emptyList();
    private static final int ICON_SIZE = 16;
    private static final int ICON_SPACING = 17;
    private static final int VISIBLE_ROWS = 3;
    private static final int VISIBLE_COLS = 8;
    private static final int SCROLLBAR_WIDTH = 12;
    private static final int SCROLLBAR_HEIGHT = 54;
    private static final int SCROLLBAR_X_OFFSET = 154;
    private static final int SCROLLBAR_Y_OFFSET = 15;
    private int hoveredRecipeIndex = -1;
    private int scrollOffset = 0;
    private boolean isDraggingScrollbar = false;
    private ResourceLocation selectedRecipeId = null;
    private static final int COLUMNS = 8;
    public static int visibleRows = 3;
    private final int itemsPerPage = 8 * visibleRows;
    private EditBox searchBox;
    private String lastSearchText = "";
    private List<RecipeHolder<?>> filteredRecipes = Collections.emptyList();
    private int dragOffsetY = 0;
    private SortType currentSortType = SortType.NAME;

    public void setClientRecipes(List<RecipeHolder<?>> recipes) {
        this.clientRecipes = new ArrayList(recipes);
        this.clientRecipes = recipes.stream().filter(r -> !r.value().getResultItem((HolderLookup.Provider)((SmartCraftingMenu)this.menu).level.registryAccess()).isEmpty()).sorted(Comparator.comparing(r -> r.id().getNamespace())).collect(Collectors.toList());
        this.updateFilteredRecipes();
        this.moveSelectedRecipeToFront();
        this.scrollOffset = 0;
    }

    public void toggleFavorite(ResourceLocation recipeId) {
        ListTag list = ((SmartCraftingMenu)this.menu).player.getPersistentData().getList(FAVORITES_TAG, 8);
        Set favorites = list.stream().map(t -> t.getAsString()).collect(Collectors.toSet());
        if (favorites.contains(recipeId.toString())) {
            favorites.remove(recipeId.toString());
        } else {
            favorites.add(recipeId.toString());
        }
        ListTag newList = new ListTag();
        for (String id : favorites) {
            newList.add((Object)StringTag.valueOf((String)id));
        }
        ((SmartCraftingMenu)this.menu).player.getPersistentData().put(FAVORITES_TAG, (Tag)newList);
        ArrayList<String> favList = new ArrayList<String>(favorites);
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncFavoriteRecipes(favList), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public SmartCraftingScreen(SmartCraftingMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        this.currentSortType = ((SmartCraftingMenu)this.menu).player.getPersistentData().getString("smart_crafting_sort_type").equals("mod") ? SortType.MOD : SortType.NAME;
        int x = (this.width - this.imageWidth) / 2 + 8;
        int y = (this.height - this.imageHeight) / 2 - 14;
        this.searchBox = new EditBox(this.font, x, y, 141, 15, (Component)Component.literal((String)"Search..."));
        this.searchBox.setMaxLength(50);
        this.searchBox.setResponder(this::onSearchTextChanged);
        this.searchBox.setFocused(true);
        this.searchBox.setBordered(true);
        this.searchBox.setVisible(true);
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        this.updateFilteredRecipes();
    }

    private void onSearchTextChanged(String text) {
        this.lastSearchText = text.toLowerCase();
        this.updateFilteredRecipes();
    }

    private void updateFilteredRecipes() {
        if (this.lastSearchText.isEmpty()) {
            this.filteredRecipes = new ArrayList(this.clientRecipes);
        } else if (this.lastSearchText.startsWith("@")) {
            String modID = this.lastSearchText.substring(1);
            this.filteredRecipes = this.clientRecipes.stream().filter(holder -> holder.id().getNamespace().toLowerCase(Locale.ROOT).contains(modID)).toList();
        } else {
            this.filteredRecipes = this.clientRecipes.stream().filter(holder -> {
                ItemStack result = holder.value().getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
                String name = result.getHoverName().getString();
                return name.toLowerCase(Locale.ROOT).contains(this.lastSearchText);
            }).toList();
        }
        if (this.currentSortType == SortType.MOD) {
            this.filteredRecipes = this.filteredRecipes.stream().sorted(Comparator.comparing(r -> r.id().getNamespace())).toList();
            if (this.selectedRecipeId != null) {
                String selectedModId = this.selectedRecipeId.getNamespace();
                ArrayList selectedModRecipes = new ArrayList();
                ArrayList otherModRecipes = new ArrayList();
                for (RecipeHolder<?> recipe2 : this.filteredRecipes) {
                    String recipeModId = recipe2.id().getNamespace();
                    if (recipeModId.equalsIgnoreCase(selectedModId)) {
                        selectedModRecipes.add(recipe2);
                        continue;
                    }
                    otherModRecipes.add(recipe2);
                }
                ArrayList combined = new ArrayList();
                combined.addAll(selectedModRecipes);
                combined.addAll(otherModRecipes);
                this.filteredRecipes = combined;
            }
        } else if (this.currentSortType == SortType.NAME) {
            this.filteredRecipes = this.filteredRecipes.stream().sorted(Comparator.comparing(recipe -> {
                ItemStack result = recipe.value().getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
                return result.getHoverName().getString().toLowerCase(Locale.ROOT);
            })).toList();
        }
        Set favoriteIds = ((SmartCraftingMenu)this.menu).player.getPersistentData().getList(FAVORITES_TAG, 8).stream().map(tag -> tag.getAsString()).collect(Collectors.toSet());
        RecipeHolder<?> selectedRecipe = null;
        ArrayList favoriteRecipes = new ArrayList();
        ArrayList otherRecipes = new ArrayList();
        for (RecipeHolder<?> recipe3 : this.filteredRecipes) {
            String idStr = recipe3.id().toString();
            if (this.selectedRecipeId != null && recipe3.id().equals((Object)this.selectedRecipeId)) {
                selectedRecipe = recipe3;
                continue;
            }
            if (favoriteIds.contains(idStr)) {
                favoriteRecipes.add(recipe3);
                continue;
            }
            otherRecipes.add(recipe3);
        }
        this.filteredRecipes = new ArrayList();
        if (selectedRecipe != null) {
            this.filteredRecipes.add(selectedRecipe);
        }
        this.filteredRecipes.addAll(favoriteRecipes);
        this.filteredRecipes.addAll(otherRecipes);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return this.searchBox.charTyped(codePoint, modifiers) || super.charTyped(codePoint, modifiers);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.searchBox.isFocused() && (this.searchBox.keyPressed(keyCode, scanCode, modifiers) || this.searchBox.canConsumeInput())) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.filteredRecipes.isEmpty() && !this.clientRecipes.isEmpty() && this.lastSearchText.isEmpty()) {
            this.filteredRecipes = this.clientRecipes;
        }
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderRecipeIngredients(guiGraphics, mouseX, mouseY);
        this.renderRecipeIcons(guiGraphics, mouseX, mouseY);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderButtonTooltip(guiGraphics, mouseX, mouseY);
        guiGraphics.blit(MODE_BUTTON_SPRITE, this.leftPos + 153, this.topPos - 14, 0.0f, 0.0f, 14, 14, 14, 14);
    }

    private void renderRecipeIcons(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        List<RecipeHolder<?>> recipes = this.filteredRecipes;
        int xStart = (this.width - this.imageWidth) / 2 + 11;
        int yStart = (this.height - this.imageHeight) / 2 + 17;
        int maxRows = (int)Math.ceil((float)recipes.size() / 8.0f);
        int maxScroll = Math.max(0, maxRows - 3);
        this.scrollOffset = Math.min(this.scrollOffset, maxScroll);
        this.scrollOffset = Math.max(this.scrollOffset, 0);
        this.hoveredRecipeIndex = -1;
        Set favoriteIds = ((SmartCraftingMenu)this.menu).player.getPersistentData().getList(FAVORITES_TAG, 8).stream().map(Tag::getAsString).collect(Collectors.toSet());
        for (int i = 0; i < recipes.size(); ++i) {
            int row = i / 8;
            int col = i % 8;
            if (row < this.scrollOffset || row >= this.scrollOffset + 3) continue;
            RecipeHolder<?> recipe = recipes.get(i);
            assert (Minecraft.getInstance().level != null);
            ItemStack resultStack = recipe.value().getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).copy();
            int iconX = xStart + col * 17;
            int iconY = yStart + (row - this.scrollOffset) * 17;
            if (recipe.id().equals((Object)this.selectedRecipeId)) {
                guiGraphics.fill(iconX - 1, iconY - 1, iconX + 16 + 1, iconY + 16 + 1, -1426063616);
            }
            guiGraphics.renderItem(resultStack, iconX, iconY);
            guiGraphics.renderItemDecorations(this.minecraft.font, resultStack, iconX, iconY);
            if (favoriteIds.contains(recipe.id().toString())) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
                guiGraphics.blit(STAR_ICON, iconX + 16 - 4, iconY, 0.0f, 0.0f, 4, 4, 4, 4);
                guiGraphics.pose().popPose();
            }
            if (mouseX < iconX || mouseX > iconX + 16 || mouseY < iconY || mouseY > iconY + 16) continue;
            this.hoveredRecipeIndex = i;
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(resultStack.getHoverName());
            tooltip.add(Component.literal((String)"Right Click to Favorite").withStyle(ChatFormatting.YELLOW));
            if (Minecraft.getInstance().options.advancedItemTooltips) {
                tooltip.add(Component.literal((String)("Recipe ID: " + String.valueOf(recipe.id()))).withStyle(ChatFormatting.DARK_GRAY));
            }
            if (SmartCraftingScreen.hasShiftDown()) {
                tooltip.add(Component.literal((String)"SHIFT to craft as many as possible!").withStyle(ChatFormatting.RED));
            }
            guiGraphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
        int guiX = (this.width - this.imageWidth) / 2;
        int guiY = (this.height - this.imageHeight) / 2;
        if (maxScroll > 0) {
            float scrollPercent = (float)this.scrollOffset / (float)maxScroll;
            int knobHeight = 15;
            int trackHeight = 54 - knobHeight;
            int knobY = (int)(scrollPercent * (float)trackHeight);
            guiGraphics.blit(SCROLL_SPRITE, guiX + 154, guiY + 15 + knobY, 0.0f, 0.0f, 12, knobHeight, 12, 15);
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingScrollbar) {
            int scrollbarY = this.topPos + 15;
            int handleHeight = 15;
            int totalRows = (int)Math.ceil((double)this.filteredRecipes.size() / 8.0);
            int maxScroll = Math.max(0, totalRows - 3);
            int relativeY = (int)mouseY - scrollbarY - this.dragOffsetY;
            float percent = Mth.clamp((float)((float)relativeY / (float)(54 - handleHeight)), (float)0.0f, (float)1.0f);
            this.scrollOffset = Mth.clamp((int)Math.round(percent * (float)maxScroll), (int)0, (int)maxScroll);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    private void moveSelectedRecipeToFront() {
        if (this.selectedRecipeId == null) {
            return;
        }
        int index = -1;
        for (int i = 0; i < this.filteredRecipes.size(); ++i) {
            if (!this.filteredRecipes.get(i).id().equals((Object)this.selectedRecipeId)) continue;
            index = i;
            break;
        }
        if (index > 0) {
            ArrayList newList = new ArrayList(this.filteredRecipes);
            RecipeHolder selectedRecipe = (RecipeHolder)newList.remove(index);
            newList.add(0, selectedRecipe);
            this.filteredRecipes = List.copyOf(newList);
        }
    }

    private void renderRecipeIngredients(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ResourceLocation tooltipTexture;
        int indexToRender = this.hoveredRecipeIndex;
        if (indexToRender == -1 && this.selectedRecipeId != null) {
            for (int i = 0; i < this.filteredRecipes.size(); ++i) {
                if (!this.filteredRecipes.get(i).id().equals((Object)this.selectedRecipeId)) continue;
                indexToRender = i;
                break;
            }
        }
        if (indexToRender == -1) {
            return;
        }
        if (this.filteredRecipes.isEmpty() || indexToRender < 0 || indexToRender >= this.filteredRecipes.size()) {
            return;
        }
        RecipeHolder<?> recipeHolder = this.filteredRecipes.get(indexToRender);
        Recipe recipe = recipeHolder.value();
        NonNullList ingredients = recipe.getIngredients();
        int gridSize = 3;
        int iconSize = 18;
        int tooltipX = this.leftPos - 58;
        int tooltipY = this.topPos;
        int recipeWidth = 3;
        int recipeHeight = 3;
        int offsetX = 0;
        int offsetY = 0;
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            recipeWidth = shaped.getWidth();
            recipeHeight = shaped.getHeight();
            offsetX = (gridSize - recipeWidth) / 2;
            offsetY = (gridSize - recipeHeight) / 2;
            tooltipTexture = CRAFTING_TOOLTIP_TEXTURE;
        } else {
            if (recipe instanceof StonecutterRecipe) {
                ItemStack[] matchingStacks;
                ResourceLocation tooltipTexture2 = STONECUTTER_TOOLTIP_TEXTURE;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, 0.0f, 0.0f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)tooltipTexture2);
                guiGraphics.blit(tooltipTexture2, tooltipX, tooltipY, 0.0f, 0.0f, 62, 62, 62, 62);
                ItemStack inputStack = ItemStack.EMPTY;
                if (!ingredients.isEmpty() && !((Ingredient)ingredients.getFirst()).isEmpty() && (matchingStacks = ((Ingredient)ingredients.getFirst()).getItems()).length > 0) {
                    inputStack = matchingStacks[0];
                }
                int inputX = tooltipX + 5;
                int inputY = tooltipY + iconSize + 5;
                guiGraphics.renderItem(inputStack, inputX, inputY);
                if (!inputStack.isEmpty()) {
                    guiGraphics.renderItemDecorations(this.minecraft.font, inputStack, inputX, inputY);
                }
                int outputX = tooltipX + 2 * iconSize + 8;
                int outputY = tooltipY + iconSize + 5;
                guiGraphics.renderItem(new ItemStack((ItemLike)Items.STONECUTTER), outputX, outputY);
                guiGraphics.pose().popPose();
                return;
            }
            tooltipTexture = CRAFTING_TOOLTIP_TEXTURE;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 0.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tooltipTexture);
        guiGraphics.blit(tooltipTexture, tooltipX, tooltipY, 0.0f, 0.0f, 62, 62, 62, 62);
        for (int slotY = 0; slotY < gridSize; ++slotY) {
            for (int slotX = 0; slotX < gridSize; ++slotX) {
                Ingredient ing;
                int ingredientIndex;
                int ingredientX = slotX - offsetX;
                int ingredientY = slotY - offsetY;
                ItemStack stack = ItemStack.EMPTY;
                if (ingredientX >= 0 && ingredientX < recipeWidth && ingredientY >= 0 && ingredientY < recipeHeight && (ingredientIndex = ingredientY * recipeWidth + ingredientX) < ingredients.size() && !(ing = (Ingredient)ingredients.get(ingredientIndex)).isEmpty()) {
                    ItemStack matchedStack = ItemStack.EMPTY;
                    ItemStack[] matchingStacks = ing.getItems();
                    if (matchingStacks.length > 0) {
                        assert (Minecraft.getInstance().player != null);
                        for (ItemStack inventoryStack : Minecraft.getInstance().player.getInventory().items) {
                            if (inventoryStack.isEmpty()) continue;
                            for (ItemStack candidate : matchingStacks) {
                                if (!ItemStack.isSameItem((ItemStack)inventoryStack, (ItemStack)candidate)) continue;
                                matchedStack = inventoryStack.copy();
                                matchedStack.setCount(1);
                                break;
                            }
                            if (matchedStack.isEmpty()) continue;
                            break;
                        }
                        if (matchedStack.isEmpty()) {
                            matchedStack = matchingStacks[0];
                        }
                        stack = matchedStack;
                    }
                }
                int x = tooltipX + slotX * iconSize + 5;
                int y = tooltipY + slotY * iconSize + 5;
                guiGraphics.renderItem(stack, x, y);
                if (stack.isEmpty()) continue;
                guiGraphics.renderItemDecorations(this.minecraft.font, stack, x, y);
            }
        }
        guiGraphics.pose().popPose();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, 8, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040, false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int iconY;
        int iconX;
        int col;
        int row;
        int i;
        int yStart;
        int xStart;
        boolean clickedOnSearchBox = this.searchBox.isMouseOver(mouseX, mouseY);
        if (MouseUtil.isMouseOver(mouseX, mouseY, this.leftPos + 153, this.topPos - 14, 14, 14)) {
            if (this.currentSortType == SortType.NAME) {
                this.currentSortType = SortType.MOD;
                PacketDistributor.sendToServer((CustomPacketPayload)new SyncSortType("mod"), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((SmartCraftingMenu)this.menu).player.getPersistentData().putString("smart_crafting_sort_type", "mod");
            } else {
                this.currentSortType = SortType.NAME;
                PacketDistributor.sendToServer((CustomPacketPayload)new SyncSortType("name"), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((SmartCraftingMenu)this.menu).player.getPersistentData().putString("smart_crafting_sort_type", "name");
            }
            this.updateFilteredRecipes();
            this.moveSelectedRecipeToFront();
            this.scrollOffset = 0;
            return true;
        }
        if (!clickedOnSearchBox) {
            this.searchBox.setFocused(false);
        }
        if (button == 0) {
            xStart = (this.width - this.imageWidth) / 2 + 11;
            yStart = (this.height - this.imageHeight) / 2 + 17;
            for (i = 0; i < this.filteredRecipes.size(); ++i) {
                ResourceLocation recipeId;
                row = i / 8;
                col = i % 8;
                if (row < this.scrollOffset || row >= this.scrollOffset + 3) continue;
                iconX = xStart + col * 17;
                iconY = yStart + (row - this.scrollOffset) * 17;
                if (!(mouseX >= (double)iconX) || !(mouseX <= (double)(iconX + 16)) || !(mouseY >= (double)iconY) || !(mouseY <= (double)(iconY + 16))) continue;
                this.selectedRecipeId = recipeId = this.filteredRecipes.get(i).id();
                this.moveSelectedRecipeToFront();
                this.scrollOffset = 0;
                assert (Minecraft.getInstance().player != null);
                boolean isShiftClick = SmartCraftingScreen.hasShiftDown();
                PacketDistributor.sendToServer((CustomPacketPayload)new SmartCraftingRecipeClickPayload(recipeId, isShiftClick), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        if (button == 1) {
            if (clickedOnSearchBox) {
                this.searchBox.setValue("");
                this.onSearchTextChanged("");
                return true;
            }
            xStart = (this.width - this.imageWidth) / 2 + 11;
            yStart = (this.height - this.imageHeight) / 2 + 17;
            for (i = 0; i < this.filteredRecipes.size(); ++i) {
                row = i / 8;
                col = i % 8;
                if (row < this.scrollOffset || row >= this.scrollOffset + 3) continue;
                iconX = xStart + col * 17;
                iconY = yStart + (row - this.scrollOffset) * 17;
                if (!(mouseX >= (double)iconX) || !(mouseX <= (double)(iconX + 16)) || !(mouseY >= (double)iconY) || !(mouseY <= (double)(iconY + 16))) continue;
                this.toggleFavorite(this.filteredRecipes.get(i).id());
                this.updateFilteredRecipes();
                return true;
            }
        }
        int scrollbarX = this.leftPos + 154;
        int scrollbarY = this.topPos + 15;
        int handleHeight = 15;
        int totalRows = (int)Math.ceil((double)this.filteredRecipes.size() / 8.0);
        int maxScroll = Math.max(0, totalRows - 3);
        if (maxScroll > 0) {
            float scrollPercent = (float)this.scrollOffset / (float)maxScroll;
            int handleY = scrollbarY + (int)((float)(54 - handleHeight) * scrollPercent);
            if (MouseUtil.isMouseOver(mouseX, mouseY, scrollbarX, handleY, 12, handleHeight)) {
                this.isDraggingScrollbar = true;
                this.dragOffsetY = (int)mouseY - handleY;
                return true;
            }
            this.isDraggingScrollbar = false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isDraggingScrollbar) {
            this.isDraggingScrollbar = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        int maxRows = (int)Math.ceil((float)this.filteredRecipes.size() / 8.0f);
        int maxScroll = Math.max(0, maxRows - 3);
        if (deltaY < 0.0 && this.scrollOffset < maxScroll) {
            ++this.scrollOffset;
        } else if (deltaY > 0.0 && this.scrollOffset > 0) {
            --this.scrollOffset;
        }
        return true;
    }

    public void renderButtonTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (MouseUtil.isMouseOver(mouseX, mouseY, this.leftPos + 153, this.topPos - 14, 14, 14)) {
            String typeString = ((SmartCraftingMenu)this.menu).player.getPersistentData().getString("smart_crafting_sort_type");
            if (typeString.equals("name")) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"block.smartcrafting.smart_crafting_table.sort_by_name").withStyle(ChatFormatting.WHITE), mouseX, mouseY);
            } else {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"block.smartcrafting.smart_crafting_table.sort_by_mod").withStyle(ChatFormatting.WHITE), mouseX, mouseY);
            }
        }
    }
}

