/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.ISyncedSetEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WideAmountData
extends AbstractData<WideAmount>
implements IContainerData {
    private WideAmount _lastValue;
    @Nullable
    private IBindableData<Double> _asDoubleBindable;

    public static WideAmountData immutable(ModContainer container, WideAmount value) {
        return WideAmountData.of(container, () -> value, CodeHelper.emptyConsumer());
    }

    public static WideAmountData empty(ModContainer container) {
        return WideAmountData.immutable(container, WideAmount.ZERO);
    }

    public static WideAmountData sampled(int frequency, ModContainer container, Supplier<@NotNull WideAmount> getter, Consumer<@NotNull WideAmount> clientSideSetter) {
        return WideAmountData.of(container, new Sampler<WideAmount>(frequency, getter), clientSideSetter);
    }

    public static WideAmountData sampled(int frequency, ModContainer container, Supplier<@NotNull WideAmount> getter) {
        return WideAmountData.of(container, new Sampler<WideAmount>(frequency, getter), CodeHelper.emptyConsumer());
    }

    public static WideAmountData of(ModContainer container, Supplier<@NotNull WideAmount> getter, Consumer<@NotNull WideAmount> clientSideSetter) {
        Preconditions.checkNotNull((Object)((Object)container), (Object)"Container must not be null.");
        WideAmountData data = container.isClientSide() ? new WideAmountData(getter, clientSideSetter) : new WideAmountData(getter);
        container.addBindableData(data);
        return data;
    }

    public static WideAmountData of(ModContainer container, Supplier<@NotNull WideAmount> getter) {
        return WideAmountData.of(container, getter, CodeHelper.emptyConsumer());
    }

    public IBindableData<Double> asDouble() {
        if (null == this._asDoubleBindable) {
            this._asDoubleBindable = AbstractData.as(0.0, doubleConsumer -> this.bind(wideAmount -> doubleConsumer.accept(wideAmount.doubleValue())));
        }
        return this._asDoubleBindable;
    }

    @Override
    @Nullable
    public ISyncedSetEntry getChangedValue() {
        WideAmount current = (WideAmount)this.getValue();
        if (!this._lastValue.equals(current)) {
            this._lastValue = current.copy();
            return new WideAmountEntry(this._lastValue);
        }
        return null;
    }

    @Override
    public ISyncedSetEntry getValueFrom(RegistryFriendlyByteBuf buffer) {
        return WideAmountEntry.from(buffer);
    }

    @Override
    public void updateFrom(ISyncedSetEntry entry) {
        if (entry instanceof WideAmountEntry) {
            WideAmountEntry record = (WideAmountEntry)entry;
            this.setClientSideValue(record.value);
            this.notify(record.value);
        }
    }

    @Override
    @Nullable
    public WideAmount defaultValue() {
        return WideAmount.ZERO;
    }

    private WideAmountData(Supplier<WideAmount> getter, Consumer<WideAmount> clientSideSetter) {
        super(getter, clientSideSetter);
    }

    private WideAmountData(Supplier<WideAmount> getter) {
        super(getter);
        this._lastValue = WideAmount.ZERO;
    }

    private record WideAmountEntry(WideAmount value) implements ISyncedSetEntry
    {
        private static WideAmountEntry from(RegistryFriendlyByteBuf buffer) {
            return new WideAmountEntry((WideAmount)WideAmount.CODECS.streamCodec().decode((Object)buffer));
        }

        @Override
        public void accept(@NotNull RegistryFriendlyByteBuf buffer) {
            WideAmount.CODECS.streamCodec().encode((Object)buffer, (Object)this.value);
        }
    }
}

