/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.ISyncedSetEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongData
extends AbstractData<Long>
implements IContainerData {
    private long _lastValue;

    public static LongData immutable(ModContainer container, long value) {
        return LongData.of(container, () -> value, CodeHelper.emptyConsumer());
    }

    public static LongData sampled(int frequency, ModContainer container, Supplier<@NotNull Long> getter, Consumer<@NotNull Long> clientSideSetter) {
        return LongData.of(container, new Sampler<Long>(frequency, getter), clientSideSetter);
    }

    public static LongData sampled(int frequency, ModContainer container, Supplier<@NotNull Long> getter) {
        return LongData.of(container, new Sampler<Long>(frequency, getter), CodeHelper.emptyConsumer());
    }

    public static LongData of(ModContainer container, Supplier<@NotNull Long> getter, Consumer<@NotNull Long> clientSideSetter) {
        Preconditions.checkNotNull((Object)((Object)container), (Object)"Container must not be null.");
        LongData data = container.isClientSide() ? new LongData(getter, clientSideSetter) : new LongData(getter);
        container.addBindableData(data);
        return data;
    }

    public static LongData of(ModContainer container, long[] array, int index) {
        Preconditions.checkNotNull((Object)array, (Object)"Array must not be null.");
        Preconditions.checkArgument((index >= 0 && index < array.length ? 1 : 0) != 0, (Object)"Index must be a valid index for the array.");
        return LongData.of(container, () -> array[index], v -> {
            array[index] = v;
        });
    }

    public static LongData of(ModContainer container, Supplier<@NotNull Long> getter) {
        return LongData.of(container, getter, CodeHelper.emptyConsumer());
    }

    @Override
    @Nullable
    public ISyncedSetEntry getChangedValue() {
        long current = (Long)this.getValue();
        if (this._lastValue != current) {
            this._lastValue = current;
            return new LongEntry(current);
        }
        return null;
    }

    @Override
    public ISyncedSetEntry getValueFrom(RegistryFriendlyByteBuf buffer) {
        return LongEntry.from(buffer);
    }

    @Override
    public void updateFrom(ISyncedSetEntry entry) {
        if (entry instanceof LongEntry) {
            LongEntry record = (LongEntry)entry;
            this.setClientSideValue(record.value);
            this.notify(record.value);
        }
    }

    @Override
    @Nullable
    public Long defaultValue() {
        return 0L;
    }

    private LongData(Supplier<Long> getter, Consumer<Long> clientSideSetter) {
        super(getter, clientSideSetter);
    }

    private LongData(Supplier<Long> getter) {
        super(getter);
        this._lastValue = 0L;
    }

    private record LongEntry(long value) implements ISyncedSetEntry
    {
        private static LongEntry from(RegistryFriendlyByteBuf buffer) {
            return new LongEntry(buffer.readLong());
        }

        @Override
        public void accept(@NotNull RegistryFriendlyByteBuf buffer) {
            buffer.writeLong(this.value);
        }
    }
}

