/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.ISyncedSetEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntData
extends AbstractData<Integer>
implements IContainerData {
    private int _lastValue;

    public static IntData immutable(ModContainer container, int value) {
        return IntData.of(container, () -> value, CodeHelper.emptyConsumer());
    }

    public static IntData sampled(int frequency, ModContainer container, Supplier<@NotNull Integer> getter, Consumer<@NotNull Integer> clientSideSetter) {
        return IntData.of(container, new Sampler<Integer>(frequency, getter), clientSideSetter);
    }

    public static IntData sampled(int frequency, ModContainer container, Supplier<@NotNull Integer> getter) {
        return IntData.of(container, new Sampler<Integer>(frequency, getter), CodeHelper.emptyConsumer());
    }

    public static IntData of(ModContainer container, Supplier<@NotNull Integer> getter, Consumer<@NotNull Integer> clientSideSetter) {
        Preconditions.checkNotNull((Object)((Object)container), (Object)"Container must not be null.");
        IntData data = container.isClientSide() ? new IntData(getter, clientSideSetter) : new IntData(getter);
        container.addBindableData(data);
        return data;
    }

    public static IntData of(ModContainer container, int[] array, int index) {
        Preconditions.checkNotNull((Object)array, (Object)"Array must not be null.");
        Preconditions.checkArgument((index >= 0 && index < array.length ? 1 : 0) != 0, (Object)"Index must be a valid index for the array.");
        return IntData.of(container, () -> array[index], v -> {
            array[index] = v;
        });
    }

    public static IntData of(ModContainer container, Supplier<@NotNull Integer> getter) {
        return IntData.of(container, getter, CodeHelper.emptyConsumer());
    }

    @Override
    @Nullable
    public ISyncedSetEntry getChangedValue() {
        int current = (Integer)this.getValue();
        if (this._lastValue != current) {
            this._lastValue = current;
            return new IntEntry(current);
        }
        return null;
    }

    @Override
    public ISyncedSetEntry getValueFrom(RegistryFriendlyByteBuf buffer) {
        return IntEntry.from(buffer);
    }

    @Override
    public void updateFrom(ISyncedSetEntry entry) {
        if (entry instanceof IntEntry) {
            IntEntry record = (IntEntry)entry;
            this.setClientSideValue(record.value);
            this.notify(record.value);
        }
    }

    @Override
    @Nullable
    public Integer defaultValue() {
        return 0;
    }

    private IntData(Supplier<Integer> getter, Consumer<Integer> clientSideSetter) {
        super(getter, clientSideSetter);
    }

    private IntData(Supplier<Integer> getter) {
        super(getter);
        this._lastValue = 0;
    }

    private record IntEntry(int value) implements ISyncedSetEntry
    {
        private static IntEntry from(RegistryFriendlyByteBuf buffer) {
            return new IntEntry(buffer.readInt());
        }

        @Override
        public void accept(@NotNull RegistryFriendlyByteBuf buffer) {
            buffer.writeInt(this.value);
        }
    }
}

