/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.client.state;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.zerono.mods.zerocore.lib.datagen.provider.client.model.ModelBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.ModelVariantBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.ModelVariantsList;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class SingleVariantBuilder
implements BlockStateGenerator {
    private final ModelBuilder _modelBuilder;
    private final Block _block;
    private final ModelVariantsList _modelVariants;

    SingleVariantBuilder(ModelBuilder modelBuilder, Block block) {
        Preconditions.checkNotNull((Object)modelBuilder, (Object)"Model builder must not be null");
        Preconditions.checkNotNull((Object)block, (Object)"Block must not be null");
        this._modelBuilder = modelBuilder;
        this._block = block;
        this._modelVariants = new ModelVariantsList(8);
    }

    public void model(ResourceLocation model) {
        Preconditions.checkNotNull((Object)model, (Object)"Model must not be null");
        this._modelVariants.add(Variant.variant().with(VariantProperties.MODEL, (Object)model));
    }

    public void variant(Variant ... variants) {
        Preconditions.checkArgument((variants.length > 0 ? 1 : 0) != 0, (Object)"At least one model variant must be provided");
        this._modelVariants.add(variants);
    }

    public void variant(Consumer<@NotNull ModelVariantBuilder> builder) {
        Preconditions.checkNotNull(builder, (Object)"Variant builder must not be null");
        ModelVariantBuilder.build(this._modelVariants, this._modelBuilder, builder);
    }

    public Block getBlock() {
        return this._block;
    }

    public JsonElement get() {
        return (JsonElement)Util.make((Object)new JsonObject(), json -> json.add("variants", (JsonElement)this._modelVariants.apply("", new JsonObject())));
    }
}

