/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import java.util.function.IntFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.neoforged.fml.LogicalSide;

public enum IoDirection implements IDebuggable,
StringRepresentable
{
    Input,
    Output;

    public static final IntFunction<IoDirection> BY_ID;
    public static final ModCodecs<IoDirection, ByteBuf> CODECS;

    public boolean isInput() {
        return this == Input;
    }

    public boolean isOutput() {
        return this == Output;
    }

    public IoDirection opposite() {
        return this.isInput() ? Output : Input;
    }

    public static IoDirection from(boolean isInput) {
        return isInput ? Input : Output;
    }

    public static IoDirection read(CompoundTag data, String key, IoDirection defaultValue) {
        String value;
        if (data.contains(key) && !Strings.isNullOrEmpty((String)(value = data.getString(key)))) {
            return IoDirection.valueOf(value);
        }
        return defaultValue;
    }

    public static void write(CompoundTag data, String key, IoDirection value) {
        data.putString(key, value.name());
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        messages.addUnlocalized("Direction: %1$s", this);
    }

    public String getSerializedName() {
        return this.name();
    }

    static {
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])IoDirection.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        CODECS = new ModCodecs(StringRepresentable.fromEnum(IoDirection::values), ByteBufCodecs.idMapper(BY_ID, Enum::ordinal));
    }
}

