/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat.computer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.zerono.mods.zerocore.lib.compat.computer.ComputerMethod;
import it.zerono.mods.zerocore.lib.compat.computer.IComputerMethodHandler;
import it.zerono.mods.zerocore.lib.compat.computer.LuaHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComputerPeripheral<P extends ComputerPeripheral<P>> {
    private static final Map<String, MethodCollection> s_methods = new Object2ObjectArrayMap();
    private final BlockEntity _tile;

    public ComputerPeripheral(BlockEntity peripheral) {
        this._tile = peripheral;
    }

    public BlockEntity getTileEntity() {
        return this._tile;
    }

    public P getPeripheral() {
        return (P)this;
    }

    public abstract String getPeripheralStaticName();

    public abstract void populateMethods(Consumer<@NotNull ComputerMethod<P>> var1);

    public Object[] invoke(String methodName, Object[] arguments) {
        return this.getCollection().invoke(this.getPeripheral(), methodName, arguments);
    }

    public Object[] invoke(int methodId, Object[] arguments) {
        return this.getCollection().invoke(this.getPeripheral(), methodId, arguments);
    }

    protected String[] getMethodsNames() {
        return this.getCollection().getMethodsNames();
    }

    protected Optional<ComputerMethod<P>> getMethod(String name) {
        return this.getCollection().getMethod(name);
    }

    protected Optional<ComputerMethod<P>> getMethod(int index) {
        return this.getCollection().getMethod(index);
    }

    public boolean equals(Object other) {
        return super.equals(other) && other instanceof ComputerPeripheral && this.getTileEntity() == ((ComputerPeripheral)other).getTileEntity();
    }

    protected static <P extends ComputerPeripheral<P>> IComputerMethodHandler<P> wrapValue(Function<P, Object> code) {
        return (peripheral, arguments) -> ComputerPeripheral.luaValueResult(code.apply(peripheral));
    }

    protected static <P extends ComputerPeripheral<P>> IComputerMethodHandler<P> wrapValue(BiFunction<P, Object[], Object> code) {
        return (peripheral, arguments) -> ComputerPeripheral.luaValueResult(code.apply(peripheral, arguments));
    }

    protected static <P extends ComputerPeripheral<P>> IComputerMethodHandler<P> wrapArray(Function<P, Object[]> code) {
        return (peripheral, arguments) -> ComputerPeripheral.luaArrayResult((Object[])code.apply(peripheral));
    }

    protected static <P extends ComputerPeripheral<P>> IComputerMethodHandler<P> wrapArray(BiFunction<P, Object[], Object[]> code) {
        return (peripheral, arguments) -> ComputerPeripheral.luaArrayResult((Object[])code.apply(peripheral, arguments));
    }

    protected static Object[] luaValueResult(@Nullable Object o) {
        Object[] objectArray;
        if (null != o) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = o;
        } else {
            objectArray = ComputerMethod.EMPTY_RESULT;
        }
        return objectArray;
    }

    protected static Object[] luaArrayResult(@Nullable Object[] o) {
        return null != o ? o : ComputerMethod.EMPTY_RESULT;
    }

    private static <P extends ComputerPeripheral<P>> Object[] helpImp(P peripheral, Object[] arguments) {
        return new Object[]{"The help() method is not implemented yet"};
    }

    private MethodCollection<P> getCollection() {
        return s_methods.computeIfAbsent(this.getPeripheralStaticName(), name -> MethodCollection.from(this::populateMethods));
    }

    private static final class MethodCollection<P extends ComputerPeripheral<P>> {
        private final String[] _names;
        private final Object2ObjectMap<String, ComputerMethod<P>> _namesMap;
        private final Int2ObjectMap<ComputerMethod<P>> _indexMap;

        public static <P extends ComputerPeripheral<P>> MethodCollection<P> from(Consumer<@NotNull Consumer<@NotNull ComputerMethod<P>>> methodsGetter) {
            ArrayList methods = Lists.newArrayList();
            methods.add(new ComputerMethod<ComputerPeripheral>("help", ComputerPeripheral::helpImp));
            methods.add(new ComputerMethod<ComputerPeripheral>("isMethodAvailable", ComputerPeripheral.wrapValue((p, arguments) -> p.getMethod(LuaHelper.getStringFromArgs(arguments, 0)).isPresent())));
            methodsGetter.accept(methods::add);
            methods.sort(Comparator.comparing(ComputerMethod::getName));
            HashMap nameMap = Maps.newHashMap();
            HashMap indexMap = Maps.newHashMap();
            String[] names = new String[methods.size()];
            int index = 0;
            for (ComputerMethod method : methods) {
                if (null == method) continue;
                names[index] = method.getName();
                nameMap.put(names[index], method);
                indexMap.put(index, method);
                ++index;
            }
            return new MethodCollection<P>(names, nameMap, indexMap);
        }

        public String[] getMethodsNames() {
            return Arrays.copyOf(this._names, this._names.length);
        }

        public Optional<ComputerMethod<P>> getMethod(String name) {
            return Optional.ofNullable((ComputerMethod)this._namesMap.get((Object)name));
        }

        public Optional<ComputerMethod<P>> getMethod(int index) {
            return Optional.ofNullable((ComputerMethod)this._indexMap.get(index));
        }

        public Object[] invoke(P peripheral, String methodName, Object[] arguments) {
            return ((ComputerMethod)this._namesMap.getOrDefault((Object)methodName, ComputerMethod.getEmptyMethod())).invoke(peripheral, arguments);
        }

        public Object[] invoke(P peripheral, int methodId, Object[] arguments) {
            return ((ComputerMethod)this._indexMap.getOrDefault(methodId, ComputerMethod.getEmptyMethod())).invoke(peripheral, arguments);
        }

        private MethodCollection(String[] names, Map<String, ComputerMethod<P>> namesMap, Map<Integer, ComputerMethod<P>> indexMap) {
            this._names = names;
            this._namesMap = Object2ObjectMaps.unmodifiable((Object2ObjectMap)new Object2ObjectArrayMap(namesMap));
            this._indexMap = Int2ObjectMaps.unmodifiable((Int2ObjectMap)new Int2ObjectArrayMap(indexMap));
        }
    }
}

