/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.helper.AdvancementHelpers;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.cyclopscore.network.packet.SendPlayerAdvancementUnlockedPacket;

public class RequestPlayerAdvancementUnlockedPacket
extends PacketCodec<RequestPlayerAdvancementUnlockedPacket> {
    public static final CustomPacketPayload.Type<RequestPlayerAdvancementUnlockedPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cyclopscore", (String)"request_player_advancement_unlocked_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestPlayerAdvancementUnlockedPacket> CODEC = RequestPlayerAdvancementUnlockedPacket.getCodec(RequestPlayerAdvancementUnlockedPacket::new);
    @CodecField
    private String advancementId;

    public RequestPlayerAdvancementUnlockedPacket() {
        super(TYPE);
    }

    public RequestPlayerAdvancementUnlockedPacket(String advancementId) {
        this();
        this.advancementId = advancementId;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(net.minecraft.world.level.Level level, Player player) {
    }

    @Override
    public void actionServer(net.minecraft.world.level.Level level, ServerPlayer player) {
        AdvancementHolder advancement = AdvancementHelpers.getAdvancement(Dist.DEDICATED_SERVER, ResourceLocation.parse((String)this.advancementId));
        if (advancement == null) {
            CyclopsCore.clog(Level.ERROR, "Received an invalid advancement " + this.advancementId + " from " + String.valueOf(player.getName()));
            return;
        }
        CyclopsCore._instance.getPacketHandler().sendToPlayer(new SendPlayerAdvancementUnlockedPacket(this.advancementId, AdvancementHelpers.hasAdvancementUnlocked((Player)player, advancement)), player);
    }
}

