/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import org.cyclops.cyclopscore.config.ConfigurableTypeCommon;
import org.cyclops.cyclopscore.config.extendedconfig.EntityClientConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigRegistry;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;

public abstract class EntityConfigCommon<M extends IModBase, T extends Entity>
extends ExtendedConfigRegistry<EntityConfigCommon<M, T>, EntityType<T>, M> {
    @Nullable
    private ItemConfigCommon<M> spawnEggItemConfig;

    public EntityConfigCommon(M mod, String namedId, Function<EntityConfigCommon<M, T>, EntityType.Builder<T>> elementConstructor) {
        this(mod, namedId, elementConstructor, null);
    }

    public EntityConfigCommon(M mod, String namedId, Function<EntityConfigCommon<M, T>, EntityType.Builder<T>> elementConstructor, @Nullable BiFunction<EntityConfigCommon<M, T>, Supplier<EntityType<T>>, ItemConfigCommon<M>> spawnEggItemConstructor) {
        super(mod, namedId, elementConstructor.andThen(builder -> builder.build(mod.getModId() + ":" + namedId)));
        if (spawnEggItemConstructor != null) {
            mod.getConfigHandler().addConfigurable((ExtendedConfigCommon)spawnEggItemConstructor.apply(this, this::getInstance));
        }
    }

    public static <M extends IModBase, T extends Mob> BiFunction<EntityConfigCommon<M, T>, Supplier<EntityType<T>>, ItemConfigCommon<M>> getDefaultSpawnEggItemConfigConstructor(M mod, String itemName, int primaryColorIn, int secondaryColorIn) {
        return EntityConfigCommon.getDefaultSpawnEggItemConfigConstructor(mod, itemName, primaryColorIn, secondaryColorIn, null);
    }

    public static <M extends IModBase, T extends Mob> BiFunction<EntityConfigCommon<M, T>, Supplier<EntityType<T>>, ItemConfigCommon<M>> getDefaultSpawnEggItemConfigConstructor(M mod, String itemName, int primaryColorIn, int secondaryColorIn, @Nullable Function<Item.Properties, Item.Properties> itemPropertiesModifier) {
        return (entityConfig, entityType) -> {
            Item.Properties itemProperties = new Item.Properties();
            if (itemPropertiesModifier != null) {
                itemProperties = (Item.Properties)itemPropertiesModifier.apply(itemProperties);
            }
            Item.Properties finalItemProperties = itemProperties;
            ItemConfigCommon<IModBase> itemConfig = new ItemConfigCommon<IModBase>(mod, itemName, arg_0 -> EntityConfigCommon.lambda$getDefaultSpawnEggItemConfigConstructor$1(mod, (Supplier)entityType, primaryColorIn, secondaryColorIn, finalItemProperties, arg_0));
            entityConfig.setSpawnEggItemConfig(itemConfig);
            return itemConfig;
        };
    }

    @Override
    public String getTranslationKey() {
        return "entity." + this.getNamedId();
    }

    @Override
    public ConfigurableTypeCommon getConfigurableType() {
        return ConfigurableTypeCommon.ENTITY;
    }

    public abstract EntityClientConfig<M, T> getEntityClientConfig();

    @Override
    public Registry<? super EntityType<T>> getRegistry() {
        return BuiltInRegistries.ENTITY_TYPE;
    }

    public void setSpawnEggItemConfig(@Nullable ItemConfigCommon spawnEggItemConfig) {
        this.spawnEggItemConfig = spawnEggItemConfig;
    }

    private static /* synthetic */ Item lambda$getDefaultSpawnEggItemConfigConstructor$1(IModBase mod, Supplier entityType, int primaryColorIn, int secondaryColorIn, Item.Properties finalItemProperties, ItemConfigCommon itemConfigSub) {
        return mod.getModHelpers().getRegistrationHelpers().createSpawnEgg(entityType, primaryColorIn, secondaryColorIn, finalItemProperties);
    }
}

