/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.tiab.common.items;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.mangorage.tiab.common.api.ICommonTimeInABottleAPI;
import org.mangorage.tiab.common.api.ITiabConfig;
import org.mangorage.tiab.common.api.ITiabItemSearch;
import org.mangorage.tiab.common.api.impl.IStoredTimeComponent;
import org.mangorage.tiab.common.api.impl.ITiabItem;
import org.mangorage.tiab.common.api.impl.ITimeAcceleratorEntity;
import org.mangorage.tiab.common.core.StoredTimeComponent;
import org.mangorage.tiab.common.misc.CommonHelper;
import org.mangorage.tiab.common.misc.CommonSoundHelper;

public class TiabItem
extends Item
implements ITiabItem {
    private final Supplier<IStoredTimeComponent> storedTimeComponentSupplier = () -> new StoredTimeComponent(0, 0);

    public TiabItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void tickPlayer(Player player) {
        this.tickPlayer(player, 1);
    }

    @Override
    public void tickPlayer(Player player, int ticks) {
        for (ITiabItemSearch handler : ICommonTimeInABottleAPI.COMMON_API.get().getSearchHandlers()) {
            ItemStack item = handler.findItem(player);
            if (item == null) continue;
            this.tickBottle(item, ticks);
            break;
        }
    }

    @Override
    public void tickBottle(ItemStack stack) {
        this.tickBottle(stack, 1);
    }

    @Override
    public void tickBottle(ItemStack stack, int ticks) {
        if (stack.getItem() != this || ticks <= 0) {
            return;
        }
        DataComponentType<IStoredTimeComponent> comp = ICommonTimeInABottleAPI.COMMON_API.get().getRegistration().getStoredTime();
        IStoredTimeComponent compInst = CommonHelper.modify(stack, comp, this.storedTimeComponentSupplier, old -> {
            if (CommonHelper.isPositive(old.stored() + ticks) && CommonHelper.isPositive(old.total() + ticks)) {
                ITiabConfig cfg = ICommonTimeInABottleAPI.COMMON_API.get().getConfig();
                return new StoredTimeComponent(Math.min(old.stored() + ticks, cfg.MAX_STORED_TIME()), old.total() + ticks);
            }
            return old;
        });
        ItemLore lore = new ItemLore(List.of(CommonHelper.getStoredTimeTranslated(compInst.stored()), CommonHelper.getTotalTimeTranslated(compInst.total())));
        stack.set(DataComponents.LORE, (Object)lore);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        ITiabConfig cfg = ICommonTimeInABottleAPI.COMMON_API.get().getConfig();
        if (level.isClientSide) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.getClickedPos();
        BlockState blockState = level.getBlockState(pos);
        BlockEntity targetTE = level.getBlockEntity(pos);
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        if (targetTE == null && !blockState.isRandomlyTicking() || blockState.is(ICommonTimeInABottleAPI.COMMON_API.get().getTagKey())) {
            return InteractionResult.FAIL;
        }
        int nextRate = 1;
        int energyRequired = this.getEnergyCost(nextRate);
        boolean isCreativeMode = player != null && player.isCreative();
        Optional o = ICommonTimeInABottleAPI.COMMON_API.get().getEntities(level, new AABB(pos)).stream().findFirst();
        if (o.isPresent()) {
            entityTA = (ITimeAcceleratorEntity)o.get();
            int currentRate = entityTA.getTimeRate();
            int usedUpTime = this.getEachUseDuration() - entityTA.getRemainingTime();
            if ((double)currentRate >= Math.pow(2.0, cfg.MAX_RATE_MULTI() - 1)) {
                return InteractionResult.SUCCESS;
            }
            nextRate = currentRate * 2;
            int timeAdded = usedUpTime / 2;
            energyRequired = this.getEnergyCost(nextRate);
            if (!this.canUse(stack, isCreativeMode, energyRequired)) {
                return InteractionResult.SUCCESS;
            }
            entityTA.setTimeRate(nextRate);
            entityTA.setRemainingTime(entityTA.getRemainingTime() + timeAdded);
        } else {
            if (!this.canUse(stack, isCreativeMode, energyRequired)) {
                return InteractionResult.SUCCESS;
            }
            entityTA = ICommonTimeInABottleAPI.COMMON_API.get().createEntity((ServerLevel)level);
            entityTA.setBlockPos(pos);
            entityTA.setRemainingTime(this.getEachUseDuration());
            level.addFreshEntity(entityTA.asEntity());
        }
        if (!isCreativeMode) {
            int required = energyRequired;
            CommonHelper.modify(stack, ICommonTimeInABottleAPI.COMMON_API.get().getRegistration().getStoredTime(), () -> new StoredTimeComponent(0, 0), old -> {
                int newStoredTime = Math.min(old.stored() - required, cfg.MAX_STORED_TIME());
                return new StoredTimeComponent(newStoredTime, old.total());
            });
        }
        CommonSoundHelper.playSound(level, pos, nextRate);
        return InteractionResult.SUCCESS;
    }

    public int getEachUseDuration() {
        return ICommonTimeInABottleAPI.COMMON_API.get().getConfig().TICKS_CONST() * ICommonTimeInABottleAPI.COMMON_API.get().getConfig().EACH_USE_DURATION();
    }

    public int getEnergyCost(int timeRate) {
        if (timeRate <= 1) {
            return this.getEachUseDuration();
        }
        return timeRate / 2 * this.getEachUseDuration();
    }

    public boolean canUse(ItemStack stack, boolean isCreativeMode, int energyRequired) {
        return this.getStoredComponent(stack).stored() >= energyRequired || isCreativeMode;
    }

    @Override
    public IStoredTimeComponent getStoredComponent(ItemStack stack) {
        return (IStoredTimeComponent)stack.getOrDefault(ICommonTimeInABottleAPI.COMMON_API.get().getRegistration().getStoredTime(), (Object)new StoredTimeComponent(0, 0));
    }

    public boolean allowComponentsUpdateAnimation(Player player, InteractionHand hand, ItemStack oldStack, ItemStack newStack) {
        return false;
    }

    public boolean allowContinuingBlockBreaking(Player player, ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return false;
    }
}

