/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.screen.custom;

import com.benbenlaw.core.util.MouseUtil;
import com.benbenlaw.strainers.screen.custom.WoodenStrainerMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WoodenStrainerScreen
extends AbstractContainerScreen<WoodenStrainerMenu> {
    Level level;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strainers", (String)"textures/gui/wooden_strainer_gui.png");

    public WoodenStrainerScreen(WoodenStrainerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.level = pMenu.level;
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (((WoodenStrainerMenu)this.menu).isCrafting()) {
            int l = ((WoodenStrainerMenu)this.menu).getScaledProgress();
            guiGraphics.blit(TEXTURE, x + 40, y + 26, 176, 14, ((WoodenStrainerMenu)this.menu).getScaledProgress() + 1, 16);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderUpgradeSlotInformation(guiGraphics, mouseX, mouseY, x, y);
    }

    private void renderUpgradeSlotInformation(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)8, (int)17, (int)16, (int)16) && ((WoodenStrainerMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && !this.hoveredSlot.hasItem()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"block.gui.mesh"), mouseX, mouseY);
        }
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)8, (int)35, (int)16, (int)16) && ((WoodenStrainerMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && !this.hoveredSlot.hasItem()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"block.gui.input_item"), mouseX, mouseY);
        }
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)17, (int)55, (int)16, (int)16)) {
            if (((WoodenStrainerMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && !this.hoveredSlot.hasItem()) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"block.gui.speed_upgrade"), mouseX, mouseY);
            }
            String ticks = String.valueOf(((WoodenStrainerMenu)this.menu).blockEntity.maxProgress);
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)(ticks + " ticks")), this.leftPos, this.topPos);
        } else if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)35, (int)55, (int)16, (int)16)) {
            if (((WoodenStrainerMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && !this.hoveredSlot.hasItem()) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"block.gui.mesh_upgrade"), mouseX, mouseY);
            }
            String meshDamage = String.valueOf(((WoodenStrainerMenu)this.menu).blockEntity.meshDamageChance * 100.0);
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)("Mesh damage chance: " + meshDamage + " %")), this.leftPos, this.topPos);
        } else if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)53, (int)55, (int)16, (int)16)) {
            if (((WoodenStrainerMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && !this.hoveredSlot.hasItem()) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"block.gui.output_upgrade"), mouseX, mouseY);
            }
            double outputChance = ((WoodenStrainerMenu)this.menu).blockEntity.outputChanceIncrease;
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)(outputChance * 100.0 + "% added to output chance")), this.leftPos, this.topPos);
        }
    }
}

