/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.recipe;

import com.benbenlaw.strainers.util.ModTags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public record StrainerRecipe(Ingredient input, String aboveBlock, SizedIngredient output, int minMeshTier, double chance) implements Recipe<RecipeInput>
{
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)1);
        ingredients.add((Object)this.input);
        return ingredients;
    }

    public boolean matches(@NotNull RecipeInput pContainer, @NotNull Level pLevel) {
        if (pLevel.isClientSide()) {
            return false;
        }
        if (this.input.test(pContainer.getItem(0))) {
            ItemStack meshItem = pContainer.getItem(1);
            return switch (this.minMeshTier) {
                case 1 -> {
                    if (meshItem.is(ModTags.Items.TIER_1_MESHES) || meshItem.is(ModTags.Items.TIER_2_MESHES) || meshItem.is(ModTags.Items.TIER_3_MESHES) || meshItem.is(ModTags.Items.TIER_4_MESHES) || meshItem.is(ModTags.Items.TIER_5_MESHES) || meshItem.is(ModTags.Items.TIER_6_MESHES)) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (meshItem.is(ModTags.Items.TIER_2_MESHES) || meshItem.is(ModTags.Items.TIER_3_MESHES) || meshItem.is(ModTags.Items.TIER_4_MESHES) || meshItem.is(ModTags.Items.TIER_5_MESHES) || meshItem.is(ModTags.Items.TIER_6_MESHES)) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (meshItem.is(ModTags.Items.TIER_3_MESHES) || meshItem.is(ModTags.Items.TIER_4_MESHES) || meshItem.is(ModTags.Items.TIER_5_MESHES) || meshItem.is(ModTags.Items.TIER_6_MESHES)) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> {
                    if (meshItem.is(ModTags.Items.TIER_4_MESHES) || meshItem.is(ModTags.Items.TIER_5_MESHES) || meshItem.is(ModTags.Items.TIER_6_MESHES)) {
                        yield true;
                    }
                    yield false;
                }
                case 5 -> {
                    if (meshItem.is(ModTags.Items.TIER_5_MESHES) || meshItem.is(ModTags.Items.TIER_6_MESHES)) {
                        yield true;
                    }
                    yield false;
                }
                case 6 -> meshItem.is(ModTags.Items.TIER_6_MESHES);
                default -> false;
            };
        }
        return false;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput container, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public double getOutputChance() {
        return this.chance;
    }

    public SizedIngredient getOutput() {
        return this.output;
    }

    public int getMinMeshTier() {
        return this.minMeshTier;
    }

    public Block getBlockAbove() {
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)this.aboveBlock));
    }

    public Fluid getFluidAbove() {
        return (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)this.aboveBlock));
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<StrainerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<StrainerRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(StrainerRecipe::input), (App)Codec.STRING.fieldOf("aboveBlock").forGetter(StrainerRecipe::aboveBlock), (App)SizedIngredient.FLAT_CODEC.fieldOf("output").forGetter(StrainerRecipe::output), (App)Codec.INT.fieldOf("minMeshTier").forGetter(StrainerRecipe::minMeshTier), (App)Codec.DOUBLE.fieldOf("chance").forGetter(StrainerRecipe::chance)).apply((Applicative)instance, StrainerRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, StrainerRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<StrainerRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, StrainerRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static StrainerRecipe read(RegistryFriendlyByteBuf buffer) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            String aboveBlock = buffer.readUtf(Short.MAX_VALUE);
            SizedIngredient output = (SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer);
            int minMeshTier = buffer.readInt();
            double chance = buffer.readDouble();
            return new StrainerRecipe(input, aboveBlock, output, minMeshTier, chance);
        }

        private static void write(RegistryFriendlyByteBuf buffer, StrainerRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            buffer.writeUtf(recipe.aboveBlock, Short.MAX_VALUE);
            SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            buffer.writeInt(recipe.minMeshTier);
            buffer.writeDouble(recipe.chance);
        }
    }

    public static class Type
    implements RecipeType<StrainerRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

