/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.recipe;

import com.benbenlaw.core.recipe.NoInventoryRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record OutputUpgradesRecipe(Ingredient input, double outputChanceIncrease) implements Recipe<NoInventoryRecipe>
{
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)1);
        ingredients.add((Object)this.input);
        return ingredients;
    }

    public boolean matches(@NotNull NoInventoryRecipe inv, @NotNull Level pLevel) {
        return true;
    }

    @NotNull
    public ItemStack assemble(@NotNull NoInventoryRecipe inv, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<OutputUpgradesRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<OutputUpgradesRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(OutputUpgradesRecipe::input), (App)Codec.DOUBLE.fieldOf("outputChanceIncrease").forGetter(OutputUpgradesRecipe::outputChanceIncrease)).apply((Applicative)instance, OutputUpgradesRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, OutputUpgradesRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<OutputUpgradesRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, OutputUpgradesRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static OutputUpgradesRecipe read(RegistryFriendlyByteBuf buffer) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            double outputChanceIncrease = buffer.readDouble();
            return new OutputUpgradesRecipe(input, outputChanceIncrease);
        }

        private static void write(RegistryFriendlyByteBuf buffer, OutputUpgradesRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            buffer.writeDouble(recipe.outputChanceIncrease);
        }
    }

    public static class Type
    implements RecipeType<OutputUpgradesRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

