/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.integration.jei;

import com.benbenlaw.strainers.integration.jei.JEIStrainersPlugin;
import com.benbenlaw.strainers.recipe.OutputUpgradesRecipe;
import java.awt.Color;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputUpgradesRecipeCategory
implements IRecipeCategory<OutputUpgradesRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"strainers", (String)"output_upgrade");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strainers", (String)"textures/gui/jei_upgrades.png");
    public static final RecipeType<OutputUpgradesRecipe> RECIPE_TYPE = RecipeType.create((String)"strainers", (String)"output_upgrade", OutputUpgradesRecipe.class);
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;
    private int tabs_used = 0;

    @Nullable
    public ResourceLocation getRegistryName(OutputUpgradesRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)OutputUpgradesRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((OutputUpgradesRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public OutputUpgradesRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 102, 19);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.DIAMOND));
    }

    @NotNull
    public RecipeType<OutputUpgradesRecipe> getRecipeType() {
        return JEIStrainersPlugin.OUTPUT_UPGRADES;
    }

    public boolean isHandled(OutputUpgradesRecipe recipe) {
        return this.tabs_used == 0;
    }

    @NotNull
    public Component getTitle() {
        return Component.literal((String)"Output Upgrades");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, OutputUpgradesRecipe recipe, IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.CATALYST, 4, 2).addIngredients(recipe.input());
    }

    public void draw(OutputUpgradesRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        @NotNull Minecraft minecraft = Minecraft.getInstance();
        double outputAddition = recipe.outputChanceIncrease();
        double outputAdditionPercentage = outputAddition * 100.0;
        guiGraphics.drawString(minecraft.font.self(), (Component)Component.literal((String)(outputAdditionPercentage + "% Added to")), 24, 2, Color.GRAY.getRGB(), false);
        guiGraphics.drawString(minecraft.font.self(), (Component)Component.literal((String)"Default Chance"), 24, 12, Color.GRAY.getRGB(), false);
    }
}

