/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.integration.jei;

import com.benbenlaw.strainers.integration.jei.JEIStrainersPlugin;
import com.benbenlaw.strainers.item.ModItems;
import com.benbenlaw.strainers.recipe.MeshUpgradesRecipe;
import java.awt.Color;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeshUpgradesRecipeCategory
implements IRecipeCategory<MeshUpgradesRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"strainers", (String)"mesh_upgrade");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strainers", (String)"textures/gui/jei_upgrades.png");
    public static final RecipeType<MeshUpgradesRecipe> RECIPE_TYPE = RecipeType.create((String)"strainers", (String)"mesh_upgrade", MeshUpgradesRecipe.class);
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;
    private int tabs_used = 0;

    public MeshUpgradesRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 102, 19);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.NETHERITE_MESH.get()));
    }

    @NotNull
    public RecipeType<MeshUpgradesRecipe> getRecipeType() {
        return JEIStrainersPlugin.MESH_UPGRADES;
    }

    public boolean isHandled(MeshUpgradesRecipe recipe) {
        return this.tabs_used == 0;
    }

    @NotNull
    public Component getTitle() {
        return Component.literal((String)"Mesh Upgrades");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public ResourceLocation getRegistryName(MeshUpgradesRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)MeshUpgradesRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((MeshUpgradesRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MeshUpgradesRecipe recipe, IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.CATALYST, 4, 2).addIngredients(recipe.input());
    }

    public void draw(MeshUpgradesRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        @NotNull Minecraft minecraft = Minecraft.getInstance();
        double outputAddition = recipe.meshDamageChance();
        double outputAdditionPercentage = outputAddition * 100.0;
        guiGraphics.drawString(minecraft.font.self(), (Component)Component.literal((String)"Mesh Damage"), 24, 2, Color.GRAY.getRGB(), false);
        guiGraphics.drawString(minecraft.font.self(), (Component)Component.literal((String)("Chance: " + outputAdditionPercentage + "%")), 24, 12, Color.GRAY.getRGB(), false);
    }
}

