/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.integration.jei;

import com.benbenlaw.strainers.block.ModBlocks;
import com.benbenlaw.strainers.integration.jei.MeshUpgradesRecipeCategory;
import com.benbenlaw.strainers.integration.jei.OutputUpgradesRecipeCategory;
import com.benbenlaw.strainers.integration.jei.StrainerRecipeCategory;
import com.benbenlaw.strainers.recipe.MeshUpgradesRecipe;
import com.benbenlaw.strainers.recipe.ModRecipes;
import com.benbenlaw.strainers.recipe.OutputUpgradesRecipe;
import com.benbenlaw.strainers.recipe.StrainerRecipe;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIStrainersPlugin
implements IModPlugin {
    public static RecipeType<StrainerRecipe> STRAINER = new RecipeType(StrainerRecipeCategory.UID, StrainerRecipe.class);
    public static RecipeType<MeshUpgradesRecipe> MESH_UPGRADES = new RecipeType(MeshUpgradesRecipeCategory.UID, MeshUpgradesRecipe.class);
    public static RecipeType<OutputUpgradesRecipe> OUTPUT_UPGRADES = new RecipeType(OutputUpgradesRecipeCategory.UID, OutputUpgradesRecipe.class);

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"strainers", (String)"jei_plugin");
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WOODEN_STRAINER.get()), new RecipeType[]{StrainerRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WOODEN_STRAINER.get()), new RecipeType[]{MeshUpgradesRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WOODEN_STRAINER.get()), new RecipeType[]{OutputUpgradesRecipeCategory.RECIPE_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new StrainerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new MeshUpgradesRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new OutputUpgradesRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        assert (Minecraft.getInstance().level != null);
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        registration.addRecipes(StrainerRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(ModRecipes.STRAINER_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(MeshUpgradesRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(ModRecipes.MESH_UPGRADE_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(OutputUpgradesRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(ModRecipes.OUTPUT_UPGRADE_TYPE.get()).stream().map(RecipeHolder::value).toList());
    }
}

