/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.integration.jei;

import java.util.Optional;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CoreRecipeCategory<T extends Recipe<?>>
implements IRecipeCategory<T> {
    private final RecipeType<T> type;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title;

    public CoreRecipeCategory(RecipeType<T> type, IDrawable background, IDrawable icon, Component title) {
        this.type = type;
        this.background = background;
        this.icon = icon;
        this.title = title;
    }

    @NotNull
    public RecipeType<T> getRecipeType() {
        return this.type;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public ResourceLocation getRegistryName(@NotNull T recipe) {
        assert (Minecraft.getInstance().level != null);
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        Optional<RecipeHolder> recipeHolder = recipeManager.getRecipes().stream().filter(holder -> holder.value().equals(recipe)).findFirst();
        return recipeHolder.map(RecipeHolder::id).orElse(null);
    }
}

