/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.datagen;

import com.benbenlaw.strainers.datagen.StrainersBlockStatesProvider;
import com.benbenlaw.strainers.datagen.StrainersBlockTags;
import com.benbenlaw.strainers.datagen.StrainersItemModelProvider;
import com.benbenlaw.strainers.datagen.StrainersItemTags;
import com.benbenlaw.strainers.datagen.StrainersLootTableProvider;
import com.benbenlaw.strainers.datagen.StrainersRecipes;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="strainers", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new StrainersRecipes(packOutput, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(StrainersLootTableProvider::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        StrainersBlockTags blockTags = new StrainersBlockTags(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        StrainersItemTags itemTags = new StrainersItemTags(packOutput, lookupProvider, blockTags, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)itemTags);
        generator.addProvider(event.includeClient(), (DataProvider)new StrainersItemModelProvider(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new StrainersBlockStatesProvider(packOutput, event.getExistingFileHelper()));
    }
}

