/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.block.entity;

import com.benbenlaw.core.block.entity.handler.IInventoryHandlingBlockEntity;
import com.benbenlaw.core.block.entity.handler.InputOutputItemHandler;
import com.benbenlaw.core.recipe.NoInventoryRecipe;
import com.benbenlaw.opolisutilities.recipe.SpeedUpgradesRecipe;
import com.benbenlaw.strainers.block.ModBlocks;
import com.benbenlaw.strainers.block.entity.ModBlockEntities;
import com.benbenlaw.strainers.block.entity.StrainerTankBlockEntity;
import com.benbenlaw.strainers.recipe.MeshUpgradesRecipe;
import com.benbenlaw.strainers.recipe.OutputUpgradesRecipe;
import com.benbenlaw.strainers.recipe.StrainerRecipe;
import com.benbenlaw.strainers.screen.custom.WoodenStrainerMenu;
import com.benbenlaw.strainers.util.ModTags;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoodenStrainerBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(25){

        protected void onContentsChanged(int slot) {
            WoodenStrainerBlockEntity.this.setChanged();
            WoodenStrainerBlockEntity.this.sync();
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            if (slot == 2 || slot == 3 || slot == 4 || slot == 1) {
                return 1;
            }
            return super.getStackLimit(slot, stack);
        }
    };
    private FakePlayer fakePlayer;
    public final ContainerData data;
    public int progress = 0;
    public int maxProgress = 220;
    public static final int INPUT_SLOT = 0;
    public static final int MESH_SLOT = 1;
    public static final int SPEED_UPGRADE = 2;
    public static final int MESH_UPGRADE = 3;
    public static final int OUTPUT_UPGRADE = 4;
    public double meshDamageChance = 1.0;
    public double outputChanceIncrease = 0.0;
    public static final int[] OUTPUT_SLOTS = new int[]{5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24};
    private final IItemHandler strainerItemHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, this::isInputSlot, this::isOutputSlot);

    public void sync() {
        ServerLevel serverLevel;
        LevelChunk chunk;
        ChunkSource chunkSource;
        Level level = this.level;
        if (level instanceof ServerLevel && (chunkSource = Objects.requireNonNull((chunk = (serverLevel = (ServerLevel)level).getChunkAt(this.getBlockPos())).getLevel()).getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(this::syncContents);
        }
    }

    public void syncContents(ServerPlayer player) {
        player.connection.send(Objects.requireNonNull(this.getUpdatePacket()));
    }

    private boolean isInputSlot(int slot, ItemStack itemStack) {
        if (slot == 1) {
            return itemStack.is(ModTags.Items.MESHES);
        }
        if (slot == 0) {
            return !itemStack.is(ModTags.Items.MESHES);
        }
        return false;
    }

    private boolean isOutputSlot(int slot) {
        for (int outputSlot : OUTPUT_SLOTS) {
            if (slot != outputSlot) continue;
            return true;
        }
        return false;
    }

    public IItemHandler getItemHandlerCapability(Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.strainerItemHandler;
    }

    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public WoodenStrainerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.WOODEN_STRAINER_BLOCK_ENTITY.get(), blockPos, blockState);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> WoodenStrainerBlockEntity.this.progress;
                    case 1 -> WoodenStrainerBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        WoodenStrainerBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        WoodenStrainerBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.fakePlayer = this.createFakePlayer(serverLevel);
        }
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.strainers.wooden_strainer");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new WoodenStrainerMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    public void handleUpdateTag(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    public void onDataPacket(@NotNull Connection connection, @NotNull ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.onDataPacket(connection, clientboundBlockEntityDataPacket, provider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.putInt("strainer.progress", this.progress);
        compoundTag.putInt("strainer.maxProgress", this.maxProgress);
        compoundTag.putDouble("strainer.meshDamageChance", this.meshDamageChance);
        compoundTag.putDouble("strainer.outputChanceIncrease", this.outputChanceIncrease);
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.progress = compoundTag.getInt("strainer.progress");
        this.maxProgress = compoundTag.getInt("strainer.maxProgress");
        this.meshDamageChance = compoundTag.getDouble("strainer.meshDamageChance");
        this.outputChanceIncrease = compoundTag.getDouble("strainer.outputChanceIncrease");
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick() {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            Level level;
            if (this.fakePlayer == null && (level = this.level) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.fakePlayer = this.createFakePlayer(serverLevel);
            }
            if (this.itemHandler.getStackInSlot(2).isEmpty()) {
                this.maxProgress = 220;
            } else {
                if (ModList.get().isLoaded("opolisutilities")) {
                    this.getMaxProgressFromUpgrade();
                }
                this.sync();
            }
            if (this.itemHandler.getStackInSlot(3).isEmpty()) {
                this.meshDamageChance = 1.0;
            } else {
                this.getMeshDamageChanceUpgrade();
                this.sync();
            }
            if (this.itemHandler.getStackInSlot(4).isEmpty()) {
                this.outputChanceIncrease = 0.0;
            } else {
                this.getOutputChanceIncrease();
                this.sync();
            }
            BlockPos pPos = this.worldPosition;
            BlockState pState = this.level.getBlockState(pPos);
            WoodenStrainerBlockEntity pBlockEntity = this;
            if (this.hasRecipe(pBlockEntity)) {
                ++pBlockEntity.progress;
                this.sync();
                WoodenStrainerBlockEntity.setChanged((Level)this.level, (BlockPos)pPos, (BlockState)pState);
                if (pBlockEntity.progress > pBlockEntity.maxProgress) {
                    this.setChanged();
                    this.craftItem(pBlockEntity);
                }
            } else {
                pBlockEntity.resetProgress();
                this.sync();
                this.setChanged();
            }
        }
    }

    @Deprecated(forRemoval=true, since="1.22 minecraft")
    public void getMaxProgressFromUpgrade() {
        assert (this.level != null);
        block0: for (RecipeHolder match : this.level.getRecipeManager().getRecipesFor((RecipeType)SpeedUpgradesRecipe.Type.INSTANCE, (RecipeInput)com.benbenlaw.opolisutilities.recipe.NoInventoryRecipe.INSTANCE, this.level)) {
            NonNullList input = ((SpeedUpgradesRecipe)match.value()).getIngredients();
            for (Ingredient ingredient : input) {
                if (!ingredient.test(this.itemHandler.getStackInSlot(2))) continue;
                this.maxProgress = ((SpeedUpgradesRecipe)match.value()).tickRate();
                continue block0;
            }
        }
    }

    public void getMeshDamageChanceUpgrade() {
        assert (this.level != null);
        block0: for (RecipeHolder match : this.level.getRecipeManager().getRecipesFor((RecipeType)MeshUpgradesRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, this.level)) {
            NonNullList<Ingredient> input = ((MeshUpgradesRecipe)match.value()).getIngredients();
            for (Ingredient ingredient : input) {
                if (!ingredient.test(this.itemHandler.getStackInSlot(3))) continue;
                this.meshDamageChance = ((MeshUpgradesRecipe)match.value()).meshDamageChance();
                continue block0;
            }
        }
    }

    public void getOutputChanceIncrease() {
        assert (this.level != null);
        block0: for (RecipeHolder match : this.level.getRecipeManager().getRecipesFor((RecipeType)OutputUpgradesRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, this.level)) {
            NonNullList<Ingredient> input = ((OutputUpgradesRecipe)match.value()).getIngredients();
            for (Ingredient ingredient : input) {
                if (!ingredient.test(this.itemHandler.getStackInSlot(4))) continue;
                this.outputChanceIncrease = ((OutputUpgradesRecipe)match.value()).outputChanceIncrease();
                continue block0;
            }
        }
    }

    private boolean hasRecipe(@NotNull WoodenStrainerBlockEntity entity) {
        Level level = entity.level;
        RecipeInput inventory = new RecipeInput(){

            @NotNull
            public ItemStack getItem(int index) {
                return WoodenStrainerBlockEntity.this.itemHandler.getStackInSlot(index);
            }

            public int size() {
                return WoodenStrainerBlockEntity.this.itemHandler.getSlots();
            }
        };
        assert (level != null);
        List allRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)StrainerRecipe.Type.INSTANCE);
        BlockPos blockPos = entity.worldPosition.above(1);
        BlockState blockAbove = level.getBlockState(blockPos);
        FluidState fluidAbove = level.getFluidState(blockPos);
        for (RecipeHolder recipeHolder : allRecipes) {
            StrainerRecipe recipe = (StrainerRecipe)recipeHolder.value();
            Fluid fluidInRecipe = recipe.getFluidAbove();
            Block blockInRecipe = recipe.getBlockAbove();
            FluidState fluidInTank = null;
            if (blockAbove.is((Block)ModBlocks.STRAINER_TANK.get())) {
                fluidInTank = ((StrainerTankBlockEntity)Objects.requireNonNull(level.getBlockEntity(blockPos))).getFluidStack().getFluid().defaultFluidState();
            }
            if (fluidInTank == null) {
                fluidInTank = fluidAbove;
            }
            boolean isFluidMatching = fluidInTank.is(fluidInRecipe) || fluidAbove.is(fluidInRecipe);
            boolean isBlockMatching = blockAbove.is(blockInRecipe) && recipe.getBlockAbove().isEmpty(blockAbove) && !blockAbove.is((Block)ModBlocks.STRAINER_TANK.get()) && fluidAbove.is(Fluids.EMPTY);
            boolean isAirBlockRecipe = blockAbove.is(blockInRecipe);
            if (!isFluidMatching && !isBlockMatching && !isAirBlockRecipe || !this.hasMeshItem(entity, recipe) || !this.hasInputItem(entity, recipe) || !this.canStartRecipe(inventory, recipe.output().getItems()[0])) continue;
            return true;
        }
        return false;
    }

    private void craftItem(@NotNull WoodenStrainerBlockEntity entity) {
        RecipeInput inventory = new RecipeInput(){

            @NotNull
            public ItemStack getItem(int index) {
                return WoodenStrainerBlockEntity.this.itemHandler.getStackInSlot(index);
            }

            public int size() {
                return WoodenStrainerBlockEntity.this.itemHandler.getSlots();
            }
        };
        assert (this.level != null);
        List allRecipes = this.level.getRecipeManager().getAllRecipesFor((RecipeType)StrainerRecipe.Type.INSTANCE);
        BlockPos blockPos = entity.worldPosition.above(1);
        BlockState blockAbove = this.level.getBlockState(blockPos);
        FluidState fluidAbove = this.level.getFluidState(blockPos);
        for (RecipeHolder recipeHolder : allRecipes) {
            int i;
            StrainerRecipe recipe = (StrainerRecipe)recipeHolder.value();
            Fluid fluidInRecipe = recipe.getFluidAbove();
            Block blockInRecipe = recipe.getBlockAbove();
            FluidState fluidInTank = null;
            if (blockAbove.is((Block)ModBlocks.STRAINER_TANK.get())) {
                fluidInTank = ((StrainerTankBlockEntity)Objects.requireNonNull(this.level.getBlockEntity(blockPos))).getFluidStack().getFluid().defaultFluidState();
            }
            if (fluidInTank == null) {
                fluidInTank = fluidAbove;
            }
            boolean isFluidMatching = fluidInTank.is(fluidInRecipe) || fluidAbove.is(fluidInRecipe);
            boolean isBlockMatching = blockAbove.is(blockInRecipe) && recipe.getBlockAbove().isEmpty(blockAbove) && !blockAbove.is((Block)ModBlocks.STRAINER_TANK.get()) && fluidAbove.is(Fluids.EMPTY);
            boolean isAirBlockRecipe = blockAbove.is(blockInRecipe);
            if (!isFluidMatching && !isBlockMatching && !isAirBlockRecipe || !this.hasMeshItem(entity, recipe) || !this.hasInputItem(entity, recipe) || !this.canStartRecipe(inventory, recipe.output().getItems()[0]) || recipe.output().ingredient().hasNoItems() || !(Math.random() < recipe.getOutputChance() + this.outputChanceIncrease)) continue;
            Item outputItem = recipe.output().getItems()[0].getItem();
            int outputCount = recipe.output().count();
            ItemStack outputStack = new ItemStack((ItemLike)outputItem, outputCount);
            boolean inserted = false;
            for (i = 5; i <= 24; ++i) {
                int maxStackSize;
                ItemStack existingStack = entity.itemHandler.getStackInSlot(i);
                if (existingStack.isEmpty() || !ItemStack.isSameItem((ItemStack)existingStack, (ItemStack)outputStack)) continue;
                int combinedCount = existingStack.getCount() + outputStack.getCount();
                if (combinedCount <= (maxStackSize = Math.min(existingStack.getMaxStackSize(), entity.itemHandler.getSlotLimit(i)))) {
                    existingStack.grow(outputStack.getCount());
                    inserted = true;
                    break;
                }
                int remaining = maxStackSize - existingStack.getCount();
                existingStack.grow(remaining);
                outputStack.shrink(remaining);
            }
            if (!inserted && !outputStack.isEmpty()) {
                for (i = 5; i <= 24; ++i) {
                    if (!entity.itemHandler.getStackInSlot(i).isEmpty()) continue;
                    entity.itemHandler.setStackInSlot(i, outputStack);
                    inserted = true;
                    break;
                }
            }
            if (inserted) continue;
            Containers.dropItemStack((Level)this.level, (double)entity.worldPosition.getX(), (double)entity.worldPosition.getY(), (double)entity.worldPosition.getZ(), (ItemStack)outputStack);
        }
        this.consumeInputItem(entity);
        this.damageMeshItem(entity);
        entity.resetProgress();
    }

    private void consumeInputItem(WoodenStrainerBlockEntity entity) {
        ItemStack inputItem = entity.itemHandler.getStackInSlot(0);
        if (!inputItem.isEmpty()) {
            inputItem.shrink(1);
            if (inputItem.getCount() <= 0) {
                entity.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
            }
        }
    }

    private void damageMeshItem(WoodenStrainerBlockEntity entity) {
        ItemStack meshItem = entity.itemHandler.getStackInSlot(1);
        if (meshItem.isDamageableItem() && Math.random() <= this.meshDamageChance) {
            meshItem.hurtAndBreak(1, (LivingEntity)this.fakePlayer, this.fakePlayer.getEquipmentSlotForItem(meshItem));
            if (meshItem.getCount() <= 0) {
                entity.itemHandler.setStackInSlot(1, ItemStack.EMPTY);
            }
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean hasMeshItem(WoodenStrainerBlockEntity entity, StrainerRecipe recipe) {
        ItemStack meshItem = entity.itemHandler.getStackInSlot(1);
        if (recipe.getMinMeshTier() == 1) {
            return meshItem.is(ModTags.Items.TIER_1_MESHES) || meshItem.is(ModTags.Items.TIER_2_MESHES) || meshItem.is(ModTags.Items.TIER_3_MESHES) || meshItem.is(ModTags.Items.TIER_4_MESHES) || meshItem.is(ModTags.Items.TIER_5_MESHES) || meshItem.is(ModTags.Items.TIER_6_MESHES);
        }
        if (recipe.getMinMeshTier() == 2) {
            return meshItem.is(ModTags.Items.TIER_2_MESHES) || meshItem.is(ModTags.Items.TIER_3_MESHES) || meshItem.is(ModTags.Items.TIER_4_MESHES) || meshItem.is(ModTags.Items.TIER_5_MESHES) || meshItem.is(ModTags.Items.TIER_6_MESHES);
        }
        if (recipe.getMinMeshTier() == 3) {
            return meshItem.is(ModTags.Items.TIER_3_MESHES) || meshItem.is(ModTags.Items.TIER_4_MESHES) || meshItem.is(ModTags.Items.TIER_5_MESHES) || meshItem.is(ModTags.Items.TIER_6_MESHES);
        }
        if (recipe.getMinMeshTier() == 4) {
            return meshItem.is(ModTags.Items.TIER_4_MESHES) || meshItem.is(ModTags.Items.TIER_5_MESHES) || meshItem.is(ModTags.Items.TIER_6_MESHES);
        }
        if (recipe.getMinMeshTier() == 5) {
            return meshItem.is(ModTags.Items.TIER_5_MESHES) || meshItem.is(ModTags.Items.TIER_6_MESHES);
        }
        if (recipe.getMinMeshTier() == 6) {
            return meshItem.is(ModTags.Items.TIER_6_MESHES);
        }
        return false;
    }

    public int getMeshTierInStrainer(WoodenStrainerBlockEntity entity, StrainerRecipe recipe) {
        if (this.hasMeshItem(entity, recipe)) {
            Item meshItem = entity.itemHandler.getStackInSlot(1).getItem();
            if (meshItem.asItem().getDefaultInstance().is(ModTags.Items.TIER_6_MESHES)) {
                return 6;
            }
            if (meshItem.asItem().getDefaultInstance().is(ModTags.Items.TIER_5_MESHES)) {
                return 5;
            }
            if (meshItem.asItem().getDefaultInstance().is(ModTags.Items.TIER_4_MESHES)) {
                return 4;
            }
            if (meshItem.asItem().getDefaultInstance().is(ModTags.Items.TIER_3_MESHES)) {
                return 3;
            }
            if (meshItem.asItem().getDefaultInstance().is(ModTags.Items.TIER_2_MESHES)) {
                return 2;
            }
            if (meshItem.asItem().getDefaultInstance().is(ModTags.Items.TIER_1_MESHES)) {
                return 1;
            }
        }
        return 0;
    }

    private boolean hasInputItem(@NotNull WoodenStrainerBlockEntity entity, @NotNull StrainerRecipe recipe) {
        ItemStack[] items = recipe.input().getItems();
        ItemStack slotItem = entity.itemHandler.getStackInSlot(0);
        for (ItemStack item : items) {
            if (!ItemStack.isSameItem((ItemStack)item, (ItemStack)slotItem)) continue;
            return true;
        }
        return false;
    }

    private boolean canStartRecipe(RecipeInput inventory, ItemStack stack) {
        int emptySlotCounter = 0;
        int occupiedSlotCounter = 0;
        for (int i = 5; i <= 24; ++i) {
            ItemStack itemStack = inventory.getItem(i);
            if (itemStack.isEmpty()) {
                ++emptySlotCounter;
                continue;
            }
            if (itemStack.getItem() == stack.getItem()) {
                int availableSpace = stack.getCount();
                if (availableSpace > 0) continue;
                return false;
            }
            ++occupiedSlotCounter;
        }
        return occupiedSlotCounter != 24 && emptySlotCounter != 0;
    }

    private FakePlayer createFakePlayer(ServerLevel level) {
        return new FakePlayer(level, new GameProfile(UUID.randomUUID(), "Strainer"));
    }
}

